/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jgroups.blocks.MethodCall;

public class CacheLoaderInterceptor
extends Interceptor {
    protected CacheLoader loader = null;
    private boolean isCustomCacheLoader;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
        this.isCustomCacheLoader = this.isCustomCacheLoaderConfigured(this.loader);
    }

    private boolean isCustomCacheLoaderConfigured(CacheLoader cl) {
        if (cl instanceof ChainingCacheLoader) {
            ChainingCacheLoader ccl = (ChainingCacheLoader)cl;
            Iterator it = ccl.getCacheLoaders().iterator();
            boolean isCustom = false;
            while (it.hasNext()) {
                CacheLoader nextCacheLoader = (CacheLoader)it.next();
                isCustom = isCustom || this.isCustomCacheLoaderConfigured(nextCacheLoader);
            }
            return isCustom;
        }
        if (cl instanceof AsyncCacheLoader) {
            CacheLoader underlying = ((AsyncCacheLoader)cl).getCacheLoader();
            return this.isCustomCacheLoaderConfigured(underlying);
        }
        return !cl.getClass().getPackage().getName().startsWith("org.jboss.cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Fqn fqn = null;
        DataNode n = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        boolean load_attributes = false;
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal)) {
            fqn = (Fqn)args[1];
            load_attributes = true;
        } else if (!meth.equals(TreeCache.removeNodeMethodLocal)) {
            if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
                fqn = (Fqn)args[1];
                load_attributes = true;
            } else if (meth.equals(TreeCache.addChildMethodLocal)) {
                fqn = (Fqn)args[1];
            } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
                fqn = (Fqn)args[0];
            } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
                fqn = (Fqn)args[0];
            }
        }
        CacheLoaderInterceptor cacheLoaderInterceptor = this;
        synchronized (cacheLoaderInterceptor) {
            if (fqn != null && (!this.cache.exists(fqn) || this.cache.exists(fqn, (Object)"jboss:internal:uninitialized"))) {
                n = this.loadNode(fqn, load_attributes);
                this.lock(fqn, 2, false);
            }
            if (meth.equals(TreeCache.getChildrenNamesMethodLocal) && fqn != null) {
                Map children;
                if (n == null) {
                    n = this.getNode(fqn);
                }
                if (!(n == null || (children = n.getChildren()) != null && n.getChildrenLoaded())) {
                    Set children_names = null;
                    try {
                        children_names = this.loader.getChildrenNames(fqn);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
                    }
                    if (children_names != null) {
                        Iterator it = children_names.iterator();
                        while (it.hasNext()) {
                            String child_name = (String)it.next();
                            Fqn child_fqn = new Fqn(n.getFqn(), child_name);
                            n.createChild(child_name, child_fqn, n, "jboss:internal:uninitialized", null);
                        }
                        this.lock(fqn, 1, true);
                    }
                    n.setChildrenLoaded(true);
                }
            }
        }
        return super.invoke(m);
    }

    protected void lock(Fqn fqn, int lock_type, boolean recursive) throws Throwable {
        if (this.cache.isNodeLockingOptimistic()) {
            return;
        }
        MethodCall meth = new MethodCall(TreeCache.lockMethodLocal, new Object[]{fqn, new Integer(lock_type), new Boolean(recursive)});
        super.invoke(meth);
    }

    protected DataNode getNode(Fqn fqn) {
        Node child_node = null;
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        Node n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize && n != null; ++i) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            child_node = n.getChild(child_name);
            n = child_node;
        }
        return n;
    }

    protected DataNode loadNode(Fqn fqn, boolean loadAttribs) {
        Node child_node = null;
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        Node n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize && n != null; ++i) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            child_node = n.getChild(child_name);
            if (child_node == null || loadAttribs && fqn.equals(tmp_fqn) && child_node.containsKey("jboss:internal:uninitialized")) {
                try {
                    boolean nodeExists;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Doing a loader.exists() in fqn " + tmp_fqn));
                    }
                    Map nodeData = null;
                    nodeData = this.loader.get(tmp_fqn);
                    boolean bl = nodeExists = nodeData != null;
                    if (!nodeExists && this.isCustomCacheLoader) {
                        this.log.warn((Object)"CacheLoader.get(Fqn) returned a null; assuming the node nodes not exist.");
                        this.log.warn((Object)"Please see http://jira.jboss.com/jira/browse/JBCACHE-118 - the CacheLoader interface has changed since JBossCache 1.3.");
                        this.log.warn((Object)"get() should return an empty Map if the node does exist but doesn't have any attributes.");
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Result " + nodeExists));
                    }
                    if (nodeExists) {
                        if (loadAttribs) {
                            if (child_node == null) {
                                child_node = n.createChild(child_name, tmp_fqn, n);
                            } else {
                                child_node.remove("jboss:internal:uninitialized");
                            }
                            child_node.put(nodeData);
                        } else {
                            child_node = n.createChild(child_name, tmp_fqn, n, "jboss:internal:uninitialized", null);
                        }
                        this.cache.notifyNodeLoaded(tmp_fqn);
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)("failed loading node " + fqn + " from CacheLoader"), t);
                }
            }
            n = child_node;
        }
        return n;
    }
}

