/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Iterator;
import java.util.List;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jgroups.blocks.MethodCall;

public abstract class BaseRpcInterceptor
extends Interceptor {
    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    protected void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            Iterator it = rsps.iterator();
            while (it.hasNext()) {
                Object rsp = it.next();
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received Throwable from remote node", (Throwable)rsp);
                }
                throw (Throwable)rsp;
            }
        }
    }

    protected void replicateCall(MethodCall call, boolean sync) throws Throwable {
        if (!sync && this.cache.getUseReplQueue() && this.cache.getReplQueue() != null) {
            this.putCallOnAsyncReplicationQueue(call);
        } else {
            List rsps = this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{call}, sync, true, this.cache.getSyncReplTimeout());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("responses=" + rsps));
            }
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }

    protected void putCallOnAsyncReplicationQueue(MethodCall call) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Putting call " + call + " on the replication queue."));
        }
        this.cache.getReplQueue().add(new MethodCall(TreeCache.replicateMethod, new Object[]{call}));
    }
}

