/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TitleFigure;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TopLineBorder;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.Messages;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmShapeEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ResourceManager;
import org.jboss.tools.hibernate.ui.view.views.OrmLabelProvider;
import org.jboss.tools.hibernate.ui.view.views.OrmModelImageVisitor;
import org.jboss.tools.hibernate.ui.view.views.OrmModelNameVisitor;

public class ShapeEditPart
extends OrmEditPart
implements PropertyChangeListener,
NodeEditPart {
    protected static OrmLabelProvider ormLabelProvider = new OrmLabelProvider(new OrmModelImageVisitor(), new OrmModelNameVisitor());

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ShapesSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        if (this.getModel() instanceof Shape) {
            Label label = new Label();
            ModelElement model = (ModelElement)this.getModel();
            while (model.getParent() != null) {
                model = model.getParent();
            }
            ConsoleConfiguration cfg = null;
            if (model instanceof OrmDiagram) {
                cfg = ((OrmDiagram)model).getConsoleConfiguration();
            }
            label.setText(ormLabelProvider.getText(this.getElement(), cfg));
            label.setBackgroundColor(this.getColor());
            label.setIcon(ormLabelProvider.getImage(this.getElement()));
            label.setLabelAlignment(1);
            label.setOpaque(true);
            TopLineBorder border = new TopLineBorder(1, 2 + this.getCastedModel().getIndent(), 1, 2);
            border.setColor(this.getOrmShapeEditPart().getColor());
            label.setBorder((Border)border);
            return label;
        }
        throw new IllegalArgumentException();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("show selection".equals(prop)) {
            this.getFigure().setBackgroundColor(this.getSelectionColor());
            this.getFigure().setForegroundColor(ResourceManager.getInstance().getColor(new RGB(255, 255, 255)));
        } else if ("hide selection".equals(prop)) {
            this.getFigure().setBackgroundColor(this.getColor());
            this.getFigure().setForegroundColor(ResourceManager.getInstance().getColor(new RGB(0, 0, 0)));
        } else if ("set focus".equals(prop)) {
            this.getViewer().select((EditPart)this);
            this.getViewer().reveal((EditPart)this);
        }
        this.refresh();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            if (this.getCastedModel().getOrmElement() instanceof Column) {
                if (this.getCastedModel().getTargetConnections().size() > 0) {
                    this.getCastedModel().getTargetConnections().get(0).getSource().setFocus();
                }
            } else if (this.getCastedModel().getSourceConnections().size() > 0) {
                this.getCastedModel().getSourceConnections().get(0).getTarget().setFocus();
            }
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected Shape getCastedModel() {
        return (Shape)this.getModel();
    }

    protected List getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        ChopboxAnchor anchor = new ChopboxAnchor(this.getFigure()){

            public Point getLocation(Point reference) {
                Rectangle r = this.getOwner().getBounds().getCopy();
                this.getOwner().translateToAbsolute((Translatable)r);
                if (this.getOwner() instanceof TitleFigure) {
                    r = ((IFigure)this.getOwner().getChildren().get(0)).getBounds().getCopy();
                    ((IFigure)this.getOwner().getChildren().get(0)).translateToAbsolute((Translatable)r);
                }
                OrmShapeEditPart part = ShapeEditPart.this.getOrmShapeEditPart();
                Point p = r.getCenter();
                p.x = reference.x < p.x ? (p.x -= part.getFigure().getBounds().width / 2) : (p.x += part.getFigure().getBounds().width / 2);
                return p;
            }
        };
        return anchor;
    }

    protected OrmShapeEditPart getOrmShapeEditPart() {
        int i = 0;
        ShapeEditPart part = this;
        while (!(part instanceof OrmShapeEditPart)) {
            part = part.getParent();
            if (i++ <= 4) continue;
            throw new RuntimeException();
        }
        return (OrmShapeEditPart)part;
    }

    protected Color getColor() {
        Object element = this.getCastedModel().getOrmElement();
        if (element instanceof PersistentClass || element instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_PersistentClassR), Integer.parseInt(Messages.Colors_PersistentClassG), Integer.parseInt(Messages.Colors_PersistentClassB)));
        }
        if (element instanceof Property || element instanceof SimpleValue) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_PersistentFieldR), Integer.parseInt(Messages.Colors_PersistentFieldG), Integer.parseInt(Messages.Colors_PersistentFieldB)));
        }
        if (element instanceof Column) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_DatabaseColumnR), Integer.parseInt(Messages.Colors_DatabaseColumnG), Integer.parseInt(Messages.Colors_DatabaseColumnB)));
        }
        if (element instanceof Table) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_DatabaseTableR), Integer.parseInt(Messages.Colors_DatabaseTableG), Integer.parseInt(Messages.Colors_DatabaseTableB)));
        }
        if (element instanceof DependantValue) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_DatabaseTableR), Integer.parseInt(Messages.Colors_DatabaseTableG), Integer.parseInt(Messages.Colors_DatabaseTableB)));
        }
        if (element instanceof OneToMany) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_PersistentFieldR), Integer.parseInt(Messages.Colors_PersistentFieldG), Integer.parseInt(Messages.Colors_PersistentFieldB)));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    protected Color getSelectionColor() {
        if (this.getCastedModel().getOrmElement() instanceof PersistentClass || this.getCastedModel().getOrmElement() instanceof Property || this.getCastedModel().getOrmElement() instanceof SimpleValue || this.getCastedModel().getOrmElement() instanceof OneToMany) {
            return ResourceManager.getInstance().getColor(new RGB(112, 161, 99));
        }
        if (this.getCastedModel().getOrmElement() instanceof Table || this.getCastedModel().getOrmElement() instanceof Column) {
            return ResourceManager.getInstance().getColor(new RGB(66, 173, 247));
        }
        return ResourceManager.getInstance().getColor(new RGB(255, 0, 0));
    }

    protected Object getElement() {
        Object element = this.getCastedModel().getOrmElement();
        if (element instanceof SpecialRootClass) {
            element = (RootClass)element;
        }
        return element;
    }

    private class ShapesSelectionEditPolicy
    extends SelectionEditPolicy {
        private ShapesSelectionEditPolicy() {
        }

        protected void hideSelection() {
            ShapeEditPart.this.getCastedModel().hideSelection();
            for (Connection element : ShapeEditPart.this.getCastedModel().getSourceConnections()) {
                element.hideSelection();
            }
            for (Connection element : ShapeEditPart.this.getCastedModel().getTargetConnections()) {
                element.hideSelection();
            }
        }

        protected void showSelection() {
            ShapeEditPart.this.getCastedModel().showSelection();
            for (Connection element : ShapeEditPart.this.getCastedModel().getSourceConnections()) {
                element.showSelection();
            }
            for (Connection element : ShapeEditPart.this.getCastedModel().getTargetConnections()) {
                element.showSelection();
            }
        }
    }
}

