/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ExpandeableShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;

public abstract class ModelElement
implements IPropertySource {
    private static final IPropertyDescriptor[] EMPTY_ARRAY = new IPropertyDescriptor[0];
    private transient PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);
    private List children = new OList();
    private ModelElement parent;

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.pcsDelegate.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.pcsDelegate.hasListeners(property)) {
            this.pcsDelegate.firePropertyChange(property, oldValue, newValue);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.pcsDelegate.removePropertyChangeListener(l);
        }
    }

    public List getChildren() {
        return this.children;
    }

    public ModelElement getParent() {
        return this.parent;
    }

    public void setParent(ModelElement element) {
        this.parent = element;
    }

    public OrmDiagram getOrmDiagram() {
        ModelElement element = this;
        while (true) {
            if (element instanceof OrmDiagram) {
                return (OrmDiagram)element;
            }
            if (element.getParent() == null) break;
            element = element.getParent();
        }
        return null;
    }

    public ExpandeableShape getExtendeableShape() {
        ModelElement element = this;
        while (true) {
            if (element instanceof ExpandeableShape) {
                return (ExpandeableShape)element;
            }
            if (element.getParent() == null) break;
            if (element.getParent() instanceof ExpandeableShape) {
                return (ExpandeableShape)element.getParent();
            }
            element = element.getParent();
        }
        return null;
    }

    public OrmShape getOrmShape() {
        ModelElement element = this;
        while (true) {
            if (element instanceof OrmShape) {
                return (OrmShape)element;
            }
            if (element.getParent() == null) break;
            element = element.getParent();
        }
        return null;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return EMPTY_ARRAY;
    }

    public Object getPropertyValue(Object id) {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    class OList
    extends ArrayList {
        public boolean add(Object item) {
            if (item instanceof ModelElement) {
                ((ModelElement)item).setParent(ModelElement.this);
            }
            return super.add(item);
        }

        public boolean remove(Object item) {
            if (item instanceof ModelElement) {
                ((ModelElement)item).setParent(null);
            }
            return super.remove(item);
        }
    }
}

