/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;

public class Connection
extends ModelElement {
    public static final String HIDE_SELECTION = "hide selection";
    public static final String SHOW_SELECTION = "show selection";
    public static final String SET_HIDEN = "set hiden";
    private Shape source;
    private Shape target;
    private int needHide;

    public Connection(Shape s, Shape newTarget) {
        if (s == null || newTarget == null || s == newTarget) {
            throw new IllegalArgumentException();
        }
        this.needHide = 2;
        this.source = s;
        this.target = newTarget;
        this.source.addConnection(this);
        this.target.addConnection(this);
    }

    public Shape getSource() {
        return this.source;
    }

    public Shape getTarget() {
        return this.target;
    }

    public void hideSelection() {
        this.firePropertyChange(HIDE_SELECTION, null, null);
        this.source.firePropertyChange(HIDE_SELECTION, null, null);
        this.target.firePropertyChange(HIDE_SELECTION, null, null);
    }

    public void showSelection() {
        this.firePropertyChange(SHOW_SELECTION, null, null);
        this.source.firePropertyChange(SHOW_SELECTION, null, null);
        this.target.firePropertyChange(SHOW_SELECTION, null, null);
    }

    public void setHidden(boolean hiden) {
        if (hiden) {
            --this.needHide;
            if (this.needHide == 0) {
                return;
            }
        } else {
            ++this.needHide;
            if (this.needHide == 1) {
                return;
            }
        }
        this.firePropertyChange(SET_HIDEN, null, new Boolean(hiden));
    }

    public boolean isHiden() {
        return this.needHide != 2;
    }
}

