/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl;

import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IDiagramInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.ILinkInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.Item;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.Items;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.LayuotConstants;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.TransitionArranger;

public class AutoLayoutImpl {
    LayuotConstants constants = new LayuotConstants();
    protected Items items;

    public void setGridStep(String gridStep) {
        this.constants.update(gridStep);
    }

    public void setItems(Items items) {
        this.items = items;
        items.setConstants(this.constants);
    }

    public void setOverride(boolean b) {
        this.items.setOverride(b);
    }

    public void setProcess(IDiagramInfo process) {
        this.items.setProcess(process);
        this.apply();
        if (this.items.override) {
            TransitionArranger a = new TransitionArranger();
            a.setItems(this.items.items);
            a.execute();
        }
    }

    private void apply() {
        this.resetTransitions();
        Item[] is = this.items.items;
        int[] yDeltas = this.items.groups.yDeltas;
        int i = 0;
        while (i < is.length) {
            if (!is[i].isSet()) {
                IItemInfo o = is[i].itemInfo;
                int x = is[i].ix * this.constants.deltaX + this.constants.indentX;
                int y = is[i].iy * this.constants.deltaY + this.constants.indentY;
                if (is[i].ix % 2 == 1) {
                    y += 16;
                }
                int[] nArray = new int[4];
                nArray[0] = x += is[i].group.xDeltas[is[i].ix] * this.constants.incX;
                nArray[1] = y += yDeltas[is[i].iy] * this.constants.incY + is[i].yIndent;
                o.setShape(nArray);
            }
            ++i;
        }
    }

    private void resetTransitions() {
        if (!this.items.override) {
            return;
        }
        Item[] is = this.items.items;
        int i = 0;
        while (i < is.length) {
            IItemInfo o = is[i].itemInfo;
            if (o instanceof ILinkInfo) {
                ((ILinkInfo)((Object)o)).setLinkShape(new int[0]);
            }
            ILinkInfo[] os = this.items.getOutput(o);
            int j = 0;
            while (j < os.length) {
                os[j].setLinkShape(new int[0]);
                ++j;
            }
            ++i;
        }
    }
}

