/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view.views;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.eclipse.console.workbench.TypeNameValueVisitor;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.jboss.tools.hibernate.ui.view.ViewPlugin;
import org.jboss.tools.hibernate.ui.view.views.HibernateUtils;

public class OrmModelNameVisitor {
    private static String SPACE = " ";
    private static String POINTER = " -> ";
    private ResourceBundle BUNDLE = ResourceBundle.getBundle(String.valueOf(OrmModelNameVisitor.class.getPackage().getName()) + ".views");
    private Map mappings = new HashMap();
    private Map dialects = new HashMap();

    public Object visitDatabaseColumn(Column column, Object argument) {
        String type = this.getColumnSqlType(column, argument);
        StringBuffer name = new StringBuffer();
        name.append(column.getName());
        if (type != null) {
            name.append(" [");
            name.append(type != null ? type.toUpperCase() : "");
            name.append(column.isNullable() ? " Nullable" : "");
            name.append(HibernateUtils.getTable(column) != null && HibernateUtils.isPrimaryKey(column) ? " PK" : "");
            name.append(HibernateUtils.getTable(column) != null && HibernateUtils.isForeignKey(column) ? " FK" : "");
            name.append("]");
        }
        return name.toString();
    }

    public String getColumnSqlType(final Column column, Object argument) {
        ConsoleConfiguration cfg = null;
        Mapping mapping = null;
        Dialect dialect = null;
        String type = null;
        if (argument instanceof ConsoleConfiguration) {
            cfg = (ConsoleConfiguration)argument;
            if (this.mappings.containsKey(cfg.getConfiguration())) {
                mapping = (Mapping)this.mappings.get(cfg);
            } else {
                mapping = cfg.getConfiguration().buildMapping();
                this.mappings.put(cfg, mapping);
            }
            try {
                String dialectName = cfg.getConfiguration().getProperty("hibernate.dialect");
                if (dialectName != null) {
                    if (this.dialects.containsKey(dialectName)) {
                        dialect = (Dialect)this.dialects.get(dialectName);
                    } else {
                        dialect = (Dialect)Class.forName(dialectName).newInstance();
                        this.dialects.put(dialectName, dialect);
                    }
                }
            }
            catch (HibernateException e) {
                ViewPlugin.getDefault().logError(e);
            }
            catch (InstantiationException e) {
                ViewPlugin.getDefault().logError(e);
            }
            catch (IllegalAccessException e) {
                ViewPlugin.getDefault().logError(e);
            }
            catch (ClassNotFoundException e) {
                ViewPlugin.getDefault().logError(e);
            }
            final Mapping fMapping = mapping;
            final Dialect fDialect = dialect;
            try {
                type = (String)cfg.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        return column.getSqlType(fDialect, fMapping);
                    }
                });
            }
            catch (Exception exception) {}
        }
        return type;
    }

    public Object visitPersistentClass(RootClass clazz, Object argument) {
        String tableName;
        StringBuffer name = new StringBuffer();
        name.append(clazz.getEntityName() != null ? clazz.getEntityName() : clazz.getClassName());
        Table table = clazz.getTable();
        if (table != null && (tableName = HibernateUtils.getTableName(table)) != null) {
            name.append(POINTER);
            name.append(tableName);
        }
        return name.toString();
    }

    public Object visitTable(Table table, Object argument) {
        StringBuffer name = new StringBuffer();
        name.append(HibernateUtils.getTableName(table));
        return name.toString();
    }

    public Object visitPersistentClass(Subclass clazz, Object argument) {
        String tableName;
        StringBuffer name = new StringBuffer();
        name.append(clazz.getEntityName());
        Table table = clazz.getTable();
        if (table != null && (tableName = HibernateUtils.getTableName(table)) != null) {
            name.append(POINTER);
            name.append(tableName);
        }
        return name.toString();
    }

    public Object visitPersistentField(Property field, Object argument) {
        String typeString;
        StringBuffer name;
        block5: {
            name = new StringBuffer();
            name.append(field.getName());
            name.append(" ");
            name.append(this.BUNDLE.getString("OrmModelNameVisitor.Colon"));
            typeString = null;
            try {
                typeString = field.getType().getReturnedClass().getName();
            }
            catch (Exception exception) {
                if (field.getValue() instanceof Component) {
                    typeString = ((Component)field.getValue()).getComponentClassName();
                }
                if (field.getValue() == null || !field.getValue().isSimpleValue()) break block5;
                typeString = ((SimpleValue)field.getValue()).getTypeName();
            }
        }
        if (typeString != null) {
            typeString = this.correctTypeString(typeString);
            name.append(SPACE);
            name.append(typeString);
            return name.toString();
        }
        Value value = field.getValue();
        String typeName = null;
        if (value != null && (typeName = (String)value.accept((ValueVisitor)new TypeNameValueVisitor(false))) != null) {
            return String.valueOf(field.getName()) + " : " + typeName;
        }
        return field.getName();
    }

    private String correctTypeString(String str) {
        String ret = str;
        while (ret.startsWith("[")) {
            ret = ret.substring(1).concat("[]");
        }
        switch (ret.toCharArray()[0]) {
            case 'Z': {
                ret = "boolean".concat(ret.substring(1));
                break;
            }
            case 'B': {
                ret = "byte".concat(ret.substring(1));
                break;
            }
            case 'C': {
                ret = "char".concat(ret.substring(1));
                break;
            }
            case 'L': {
                ret = ret.substring(1);
                break;
            }
            case 'D': {
                ret = "double".concat(ret.substring(1));
                break;
            }
            case 'F': {
                ret = "float".concat(ret.substring(1));
                break;
            }
            case 'I': {
                ret = "int".concat(ret.substring(1));
                break;
            }
            case 'J': {
                ret = "long".concat(ret.substring(1));
                break;
            }
            case 'S': {
                ret = "short".concat(ret.substring(1));
            }
        }
        return ret;
    }

    public Object visitCollectionKeyMapping(DependantValue mapping, Object argument) {
        return "key";
    }

    public Object visitComponentMapping(Component mapping, Object argument) {
        return "element";
    }
}

