/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UnionSubclass;
import org.jboss.tools.hibernate.ui.view.views.OrmModelImageVisitor;
import org.jboss.tools.hibernate.ui.view.views.OrmModelNameVisitor;

public class OrmLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Map imageCache = new HashMap(25);
    private OrmModelImageVisitor ormModelImageVisitor;
    private OrmModelNameVisitor ormModelNameVisitor;

    public OrmLabelProvider(OrmModelImageVisitor imageVisitor, OrmModelNameVisitor nameVisitor) {
        this.ormModelImageVisitor = imageVisitor;
        this.ormModelNameVisitor = nameVisitor;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof RootClass) {
            descriptor = (ImageDescriptor)((RootClass)element).accept((PersistentClassVisitor)this.ormModelImageVisitor);
        } else if (element instanceof UnionSubclass) {
            descriptor = (ImageDescriptor)((UnionSubclass)element).accept((PersistentClassVisitor)this.ormModelImageVisitor);
        } else if (element instanceof SingleTableSubclass) {
            descriptor = (ImageDescriptor)((SingleTableSubclass)element).accept((PersistentClassVisitor)this.ormModelImageVisitor);
        } else if (element instanceof JoinedSubclass) {
            descriptor = (ImageDescriptor)((JoinedSubclass)element).accept((PersistentClassVisitor)this.ormModelImageVisitor);
        } else if (element instanceof Subclass) {
            descriptor = (ImageDescriptor)((Subclass)element).accept((PersistentClassVisitor)this.ormModelImageVisitor);
        } else if (element instanceof Property) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitPersistentField((Property)element);
        } else if (element instanceof Table) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitDatabaseTable((Table)element);
        } else if (element instanceof Column) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitDatabaseColumn((Column)element);
        } else if (element instanceof DependantValue) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitComponentKeyMapping((DependantValue)element);
        } else if (element instanceof Component) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitComponentMapping((Component)element);
        } else if (element instanceof ManyToOne) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitManyToOneMapping((ManyToOne)element);
        } else if (element instanceof OneToMany) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitOneToManyMapping((OneToMany)element);
        } else if (element instanceof Any) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitAnyMapping((Any)element);
        } else if (element instanceof SimpleValue) {
            descriptor = (ImageDescriptor)this.ormModelImageVisitor.visitSimpleValueMapping((SimpleValue)element);
        } else {
            return null;
        }
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element, ConsoleConfiguration cfg) {
        if (element instanceof RootClass) {
            String name = (String)this.ormModelNameVisitor.visitPersistentClass((RootClass)element, null);
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof Table) {
            String name = (String)this.ormModelNameVisitor.visitTable((Table)element, null);
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof Subclass) {
            String name = (String)this.ormModelNameVisitor.visitPersistentClass((Subclass)element, null);
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof Property) {
            String name = (String)this.ormModelNameVisitor.visitPersistentField((Property)element, null);
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof Column) {
            String name = (String)this.ormModelNameVisitor.visitDatabaseColumn((Column)element, cfg);
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof OneToMany || element instanceof ManyToOne) {
            String name = "element";
            if (name == null) {
                return "OrmElement";
            }
            return name;
        }
        if (element instanceof SimpleValue) {
            if (element instanceof DependantValue) {
                String name = (String)this.ormModelNameVisitor.visitCollectionKeyMapping((DependantValue)element, null);
                if (name == null) {
                    return "OrmElement";
                }
                return name;
            }
            if (element instanceof Component) {
                String name = (String)this.ormModelNameVisitor.visitComponentMapping((Component)element, null);
                if (name == null) {
                    return "OrmElement";
                }
                return name;
            }
            return "element";
        }
        if (element instanceof String) {
            return (String)element;
        }
        throw this.unknownElement(element);
    }

    protected RuntimeException unknownElement(Object element) {
        if (element != null && element.getClass() != null) {
            return new RuntimeException("Unknown type of element in tree of type: " + element.getClass().getName());
        }
        return new RuntimeException("Unknown type of element in tree of type: " + element);
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    public Color getForeground(Object element) {
        if (element instanceof RootClass) {
            return Display.getCurrent().getSystemColor(6);
        }
        if (element instanceof Property) {
            return Display.getCurrent().getSystemColor(10);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        return null;
    }
}

