/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.view.ViewPlugin;
import org.jboss.tools.hibernate.ui.view.views.ObjectEditorInput;
import org.jboss.tools.hibernate.ui.view.views.OpenActionDelegate;

public class OpenDiagramActionDelegate
extends OpenActionDelegate {
    private HashMap hashMap = new HashMap();

    public void run(IAction action) {
        ObjectPluginAction objectPluginAction = (ObjectPluginAction)action;
        HashMap<ConsoleConfiguration, HashSet<PersistentClass>> mapCC_PCs = new HashMap<ConsoleConfiguration, HashSet<PersistentClass>>();
        TreePath[] paths = ((TreeSelection)objectPluginAction.getSelection()).getPaths();
        int i = 0;
        while (i < paths.length) {
            Object last_el = paths[i].getLastSegment();
            if (last_el instanceof PersistentClass) {
                PersistentClass persClass = (PersistentClass)last_el;
                ConsoleConfiguration consoleConfiguration = (ConsoleConfiguration)paths[i].getFirstSegment();
                HashSet<PersistentClass> setPC = (HashSet<PersistentClass>)mapCC_PCs.get(consoleConfiguration);
                if (setPC == null) {
                    setPC = new HashSet<PersistentClass>();
                    mapCC_PCs.put(consoleConfiguration, setPC);
                }
                setPC.add(persClass);
            }
            ++i;
        }
        for (ConsoleConfiguration consoleConfiguration : mapCC_PCs.keySet()) {
            Set setPC = (Set)mapCC_PCs.get(consoleConfiguration);
            try {
                this.openEditor(setPC, consoleConfiguration);
            }
            catch (PartInitException e) {
                ViewPlugin.getDefault().logError("Can't open mapping view.", e);
            }
        }
    }

    public IEditorPart openEditor(PersistentClass persClass, ConsoleConfiguration consoleConfiguration) throws PartInitException {
        ObjectEditorInput input = (ObjectEditorInput)this.hashMap.get(persClass.getRootClass());
        IJavaProject proj = ProjectUtils.findJavaProject((ConsoleConfiguration)consoleConfiguration);
        if (input == null) {
            input = new ObjectEditorInput(consoleConfiguration, persClass.getRootClass(), proj);
            this.hashMap.put(persClass.getRootClass(), input);
        }
        return IDE.openEditor((IWorkbenchPage)ViewPlugin.getPage(), (IEditorInput)input, (String)"org.jboss.tools.hibernate.ui.veditor.editors.visualeditor");
    }

    public IEditorPart openEditor(Set setPC, ConsoleConfiguration consoleConfiguration) throws PartInitException {
        if (setPC.size() <= 0) {
            return null;
        }
        RootClass[] rcArr = new RootClass[setPC.size()];
        String id = "";
        PersistentClass persClass2 = null;
        int i = 0;
        for (PersistentClass persClass2 : setPC) {
            id = String.valueOf(id) + "@" + persClass2.toString();
            rcArr[i++] = persClass2.getRootClass();
        }
        ObjectEditorInput input = (ObjectEditorInput)this.hashMap.get(id);
        IJavaProject proj = ProjectUtils.findJavaProject((ConsoleConfiguration)consoleConfiguration);
        if (input == null) {
            input = new ObjectEditorInput(consoleConfiguration, rcArr, proj);
            this.hashMap.put(id, input);
        }
        return IDE.openEditor((IWorkbenchPage)ViewPlugin.getPage(), (IEditorInput)input, (String)"org.jboss.tools.hibernate.ui.veditor.editors.visualeditor");
    }
}

