/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view.views;

import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;

public class HibernateUtils {
    public static String getTableName(String catalog, String schema, String name) {
        return String.valueOf(catalog != null ? String.valueOf(catalog) + "." : "") + (schema != null ? String.valueOf(schema) + "." : "") + name;
    }

    public static String getTableName(Table table) {
        return HibernateUtils.getTableName(table.getCatalog(), table.getSchema(), table.getName());
    }

    public static String getPersistentClassName(PersistentClass rootClass) {
        if (rootClass == null) {
            return "";
        }
        return rootClass.getEntityName() != null ? rootClass.getEntityName() : rootClass.getClassName();
    }

    public static String getPersistentClassName(String className) {
        if (className == null) {
            return "";
        }
        if (className.indexOf(".") < 0) {
            return "default." + className;
        }
        return className;
    }

    public static boolean isPrimaryKey(Column column) {
        Table table = HibernateUtils.getTable(column);
        return table != null && table.getPrimaryKey() != null && table.getPrimaryKey().containsColumn(column);
    }

    public static boolean isForeignKey(Column column) {
        Table table = HibernateUtils.getTable(column);
        if (table != null) {
            Iterator iter = table.getForeignKeyIterator();
            while (iter.hasNext()) {
                ForeignKey fk = (ForeignKey)iter.next();
                if (!fk.containsColumn(column)) continue;
                return true;
            }
        }
        return false;
    }

    public static Table getTable(Column column) {
        if (column.getValue() != null) {
            return column.getValue().getTable();
        }
        return null;
    }
}

