/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.TotalTokenProtocolObserver;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherTotalTokenTest
extends TestCase {
    String props = null;
    final int NUM_ITEMS = 10;
    static Logger logger = Logger.getLogger((String)RpcDispatcherTotalTokenTest.class.getName());
    static /* synthetic */ Class class$java$lang$String;

    public RpcDispatcherTotalTokenTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.props = "UDP(mcast_recv_buf_size=80000;mcast_send_buf_size=150000;mcast_port=45566;mcast_addr=228.8.8.8;ip_ttl=32):PING(timeout=2000;num_initial_members=3):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=600,1200,2000,2500):FRAG(frag_size=8096;down_thread=false;up_thread=false):TOTAL_TOKEN(unblock_sending=10;block_sending=50):pbcast.GMS(print_local_addr=true;join_timeout=3000;join_retry_timeout=2000;shun=true):STATE_TRANSFER:QUEUE";
    }

    public void tearDown() throws Exception {
    }

    public void test() throws Exception {
        DispatcherTask t1 = new DispatcherTask("Task1", this.props);
        DispatcherTask t2 = new DispatcherTask("Task2", this.props);
        DispatcherTask t3 = new DispatcherTask("Task3", this.props);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        Thread rTask3 = new Thread(t3);
        TotalTokenProtocolObserver po1 = new TotalTokenProtocolObserver(t1.getChannel());
        TotalTokenProtocolObserver po2 = new TotalTokenProtocolObserver(t2.getChannel());
        TotalTokenProtocolObserver po3 = new TotalTokenProtocolObserver(t3.getChannel());
        Util.sleep(1000L);
        rTask1.start();
        rTask2.start();
        rTask3.start();
        while (!(t1.finished() && t2.finished() && t3.finished())) {
            Util.sleep(1000L);
        }
        t1.close();
        t2.close();
        t3.close();
        RpcDispatcherTotalTokenTest.assertTrue((boolean)t1.result());
        RpcDispatcherTotalTokenTest.assertTrue((boolean)t2.result());
        RpcDispatcherTotalTokenTest.assertTrue((boolean)t3.result());
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherTotalTokenTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherTotalTokenTest.suite());
    }

    public class DispatcherTask
    implements Runnable {
        protected String taskName;
        protected boolean finished;
        JChannel channel;
        RpcDispatcher disp;
        RspList rsp_list;
        int base;
        boolean bTest;

        public DispatcherTask(String taskName, String jgProps) throws Exception {
            this.taskName = taskName;
            this.base = 0;
            this.finished = false;
            this.bTest = true;
            this.channel = new JChannel(jgProps);
            this.disp = new RpcDispatcher((Channel)this.channel, null, null, this);
            this.channel.connect("RpcDispatcherTestGroup");
        }

        public synchronized int print(String tag) throws Exception {
            return this.base++;
        }

        public JChannel getChannel() {
            return this.channel;
        }

        public boolean finished() {
            return this.finished;
        }

        public boolean result() {
            return this.bTest;
        }

        protected boolean checkResult(RspList rsp) {
            boolean result = true;
            Vector results = rsp.getResults();
            Object retval = null;
            if (results.size() > 0 && rsp.numSuspectedMembers() == 0) {
                retval = results.elementAt(0);
                for (int i = 1; i < results.size(); ++i) {
                    Object data = results.elementAt(i);
                    boolean test = data.equals(retval);
                    if (test) continue;
                    logger.error((Object)("Task " + this.taskName + ":Reference value differs from returned value " + retval + " != " + data));
                    result = false;
                }
            }
            return result;
        }

        public void run() {
            logger.debug((Object)("Task " + this.taskName + " View is :" + this.channel.getView()));
            for (int i = 0; i < 10 && this.bTest; ++i) {
                Util.sleep(100L);
                try {
                    MethodCall call = new MethodCall("print", new Object[]{this.taskName + '_' + i}, new String[]{(class$java$lang$String == null ? RpcDispatcherTotalTokenTest.class$("java.lang.String") : class$java$lang$String).getName()});
                    this.rsp_list = this.disp.callRemoteMethods(null, call, 2, 0L);
                    logger.debug((Object)("Task " + this.taskName + " Responses: " + this.rsp_list));
                    this.bTest = this.checkResult(this.rsp_list);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)"Unexpected error", (Throwable)ex);
                }
            }
            this.finished = true;
        }

        public void close() {
            try {
                logger.debug((Object)"Stopping dispatcher");
                this.disp.stop();
                logger.debug((Object)"Stopping dispatcher: -- done");
                Util.sleep(200L);
                logger.debug((Object)"Closing channel");
                this.channel.close();
                logger.debug((Object)"Closing channel: -- done");
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }
}

