/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.logging;

import java.io.IOException;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.IPath;

public class PluginFileAppender
extends RollingFileAppender {
    private IPath stateLocation;
    private boolean activateOptionsPending;
    private boolean translatePath = true;

    public PluginFileAppender() {
    }

    public PluginFileAppender(Layout layout, IPath stateLocation) {
        this.setLayout(layout);
        this.setStateLocation(stateLocation);
    }

    public PluginFileAppender(Layout layout, IPath stateLocation, String file, boolean append) throws IOException {
        this.setLayout(layout);
        this.setStateLocation(stateLocation);
        this.setFile(file);
        this.setAppend(append);
        this.activateOptions();
    }

    public PluginFileAppender(Layout layout, IPath stateLocation, String file) throws IOException {
        this.setLayout(layout);
        this.setStateLocation(stateLocation);
        this.setFile(file);
        this.activateOptions();
    }

    void setStateLocation(IPath stateLocation) {
        this.stateLocation = stateLocation;
        if (this.stateLocation != null && this.activateOptionsPending) {
            this.activateOptionsPending = false;
            this.setFile(this.getFile());
            this.activateOptions();
        }
    }

    public void setFile(String file) {
        super.setFile(this.getTranslatedFileName(file));
    }

    public void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        if (this.stateLocation == null) {
            throw new IOException("Missing Plugin State Location.");
        }
        fileName = this.translatePath ? this.getTranslatedFileName(fileName) : fileName;
        super.setFile(fileName, append, bufferedIO, bufferSize);
    }

    public void activateOptions() {
        if (this.stateLocation == null) {
            this.activateOptionsPending = true;
            return;
        }
        this.translatePath = false;
        super.activateOptions();
        this.translatePath = true;
    }

    private String getTranslatedFileName(String file) {
        if (this.stateLocation == null || file == null) {
            return file;
        }
        if ((file = file.trim()).length() == 0) {
            return file;
        }
        int index = file.lastIndexOf(47);
        if (index == -1) {
            index = file.lastIndexOf(92);
        }
        if (index != -1) {
            file = file.substring(index + 1);
        }
        IPath newPath = this.stateLocation.append(file);
        return newPath.toString();
    }

    public void append(LoggingEvent event) {
        super.append(event);
    }
}

