/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.FixedConnectionAnchor;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class LEDFigure
extends NodeFigure
implements HandleBounds {
    protected static final Dimension SIZE = new Dimension(61, 47);
    public static final Color DISPLAY_SHADOW = new Color(null, 57, 117, 90);
    public static final Color DISPLAY_TEXT = new Color(null, 255, 199, 16);
    protected static final Font DISPLAY_FONT = new Font(null, "", 19, 0);
    protected static PointList connector = new PointList();
    protected static PointList bottomConnector = new PointList();
    protected static Rectangle displayRectangle = new Rectangle(15, 11, 31, 25);
    protected static Rectangle displayShadow = new Rectangle(14, 10, 32, 26);
    protected static Rectangle displayHighlight = new Rectangle(15, 11, 32, 26);
    protected static Point valuePoint = new Point(16, 10);
    protected static final int[] GAP_CENTERS_X;
    protected static final int Y1 = 2;
    protected static final int Y2 = 44;
    protected String value;

    static {
        connector.addPoint(-2, 0);
        connector.addPoint(1, 0);
        connector.addPoint(2, 1);
        connector.addPoint(2, 5);
        connector.addPoint(-1, 5);
        connector.addPoint(-1, 1);
        bottomConnector.addPoint(-2, 0);
        bottomConnector.addPoint(1, 0);
        bottomConnector.addPoint(2, -1);
        bottomConnector.addPoint(2, -5);
        bottomConnector.addPoint(-1, -5);
        bottomConnector.addPoint(-1, -1);
        GAP_CENTERS_X = new int[]{8, 23, 38, 53};
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public LEDFigure() {
        this.getBounds().width = 61;
        this.getBounds().height = 47;
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 51;
        this.connectionAnchors.put(LED.TERMINAL_1_IN, c);
        this.inputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 36;
        this.connectionAnchors.put(LED.TERMINAL_2_IN, c);
        this.inputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 21;
        this.connectionAnchors.put(LED.TERMINAL_3_IN, c);
        this.inputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 6;
        this.connectionAnchors.put(LED.TERMINAL_4_IN, c);
        this.inputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 51;
        c.topDown = false;
        this.connectionAnchors.put(LED.TERMINAL_1_OUT, c);
        this.outputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 36;
        c.topDown = false;
        this.connectionAnchors.put(LED.TERMINAL_2_OUT, c);
        this.outputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 21;
        c.topDown = false;
        this.connectionAnchors.put(LED.TERMINAL_3_OUT, c);
        this.outputConnectionAnchors.addElement(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 6;
        c.topDown = false;
        this.connectionAnchors.put(LED.TERMINAL_4_OUT, c);
        this.outputConnectionAnchors.addElement(c);
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(2, 0, 2, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        g.setBackgroundColor(LogicColorConstants.logicGreen);
        g.setForegroundColor(LogicColorConstants.connectorGreen);
        g.fillRectangle(0, 2, r.width, r.height - 4);
        int right = r.width - 1;
        g.drawLine(0, 2, right, 2);
        g.drawLine(0, 2, 0, 44);
        g.setForegroundColor(LogicColorConstants.connectorGreen);
        g.drawLine(0, 44, right, 44);
        g.drawLine(right, 2, right, 44);
        g.setForegroundColor(ColorConstants.listBackground);
        int i = 0;
        while (i < 4) {
            g.drawLine(GAP_CENTERS_X[i] - 2, 2, GAP_CENTERS_X[i] + 3, 2);
            g.drawLine(GAP_CENTERS_X[i] - 2, 44, GAP_CENTERS_X[i] + 3, 44);
            ++i;
        }
        g.setForegroundColor(LogicColorConstants.connectorGreen);
        g.setBackgroundColor(LogicColorConstants.connectorGreen);
        i = 0;
        while (i < 4) {
            connector.translate(GAP_CENTERS_X[i], 0);
            g.fillPolygon(connector);
            g.drawPolygon(connector);
            connector.translate(-GAP_CENTERS_X[i], 0);
            bottomConnector.translate(GAP_CENTERS_X[i], r.height - 1);
            g.fillPolygon(bottomConnector);
            g.drawPolygon(bottomConnector);
            bottomConnector.translate(-GAP_CENTERS_X[i], -r.height + 1);
            ++i;
        }
        g.setBackgroundColor(LogicColorConstants.logicHighlight);
        g.fillRectangle(displayHighlight);
        g.setBackgroundColor(DISPLAY_SHADOW);
        g.fillRectangle(displayShadow);
        g.setBackgroundColor(ColorConstants.black);
        g.fillRectangle(displayRectangle);
        g.setFont(DISPLAY_FONT);
        g.setForegroundColor(DISPLAY_TEXT);
        g.drawText(this.value, valuePoint);
    }

    public void setValue(int val) {
        this.value = String.valueOf(val);
        if (val < 10) {
            this.value = "0" + this.value;
        }
        this.repaint();
    }

    public String toString() {
        return "LEDFigure";
    }
}

