/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicNumberCellEditorValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DimensionPropertySource
implements IPropertySource {
    public static String ID_WIDTH = "width";
    public static String ID_HEIGHT = "height";
    protected static IPropertyDescriptor[] descriptors;
    protected Dimension dimension = null;

    static {
        TextPropertyDescriptor widthProp = new TextPropertyDescriptor((Object)ID_WIDTH, LogicMessages.DimensionPropertySource_Property_Width_Label);
        widthProp.setValidator((ICellEditorValidator)LogicNumberCellEditorValidator.instance());
        TextPropertyDescriptor heightProp = new TextPropertyDescriptor((Object)ID_HEIGHT, LogicMessages.DimensionPropertySource_Property_Height_Label);
        heightProp.setValidator((ICellEditorValidator)LogicNumberCellEditorValidator.instance());
        descriptors = new IPropertyDescriptor[]{widthProp, heightProp};
    }

    public DimensionPropertySource(Dimension dimension) {
        this.dimension = dimension.getCopy();
    }

    public Object getEditableValue() {
        return this.dimension.getCopy();
    }

    public Object getPropertyValue(Object propName) {
        return this.getPropertyValue((String)propName);
    }

    public Object getPropertyValue(String propName) {
        if (ID_HEIGHT.equals(propName)) {
            return new String(new Integer(this.dimension.height).toString());
        }
        if (ID_WIDTH.equals(propName)) {
            return new String(new Integer(this.dimension.width).toString());
        }
        return null;
    }

    public void setPropertyValue(Object propName, Object value) {
        this.setPropertyValue((String)propName, value);
    }

    public void setPropertyValue(String propName, Object value) {
        Integer newInt;
        if (ID_HEIGHT.equals(propName)) {
            newInt = new Integer((String)value);
            this.dimension.height = newInt;
        }
        if (ID_WIDTH.equals(propName)) {
            newInt = new Integer((String)value);
            this.dimension.width = newInt;
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public void resetPropertyValue(String propName) {
    }

    public void resetPropertyValue(Object propName) {
    }

    public boolean isPropertySet(Object propName) {
        return true;
    }

    public boolean isPropertySet(String propName) {
        return ID_HEIGHT.equals(propName) || ID_WIDTH.equals(propName);
    }

    public String toString() {
        return new String("(" + this.dimension.width + "," + this.dimension.height + ")");
    }
}

