/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import com.ibm.icu.text.BreakIterator;
import java.beans.PropertyChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.AbstractTextPart;
import org.eclipse.gef.examples.text.edit.FontCache;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;
import org.eclipse.swt.graphics.Font;

public class TextFlowPart
extends AbstractTextPart {
    private static BreakIterator wordIterator = null;
    private Font localFont;

    public TextFlowPart(Object model) {
        this.setModel(model);
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        TextFlow flow = new TextFlow();
        if (((TextRun)this.getModel()).getType() == 5) {
            flow.setLayoutManager((LayoutManager)new SimpleTextLayout(flow));
        }
        return flow;
    }

    public void deactivate() {
        super.deactivate();
        if (this.localFont != null) {
            FontCache.checkIn(this.localFont);
        }
    }

    public CaretInfo getCaretPlacement(int offset, boolean trailing) {
        Assert.isTrue((offset <= this.getLength() ? 1 : 0) != 0);
        if (trailing) {
            if (offset > 0) {
                --offset;
            } else {
                trailing = false;
                new RuntimeException("unexpected condition").printStackTrace();
            }
        }
        return this.getTextFlow().getCaretPlacement(offset, trailing);
    }

    public int getLength() {
        return this.getTextFlow().getText().length();
    }

    TextFlow getTextFlow() {
        return (TextFlow)this.getFigure();
    }

    public void getTextLocation(CaretRequest search, SearchResult result) {
        if (search.getType() == CaretRequest.LINE_BOUNDARY) {
            this.searchLineBoundary(search, result);
        } else if (search.getType() == CaretRequest.COLUMN) {
            this.searchColumn(search, result);
        } else if (search.getType() == CaretRequest.ROW) {
            this.searchRow(search, result);
        } else if (search.getType() == CaretRequest.WORD_BOUNDARY) {
            this.searchWordBoundary(search, result);
        } else if (search.getType() == CaretRequest.LOCATION) {
            this.searchLocation(search, result);
        } else if (this.getParent() instanceof TextEditPart) {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("text")) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        TextRun textRun = (TextRun)this.getModel();
        Style style = textRun.getContainer().getStyle();
        Font font = FontCache.checkOut(style.getFontFamily(), style.getFontHeight(), style.isBold(), style.isItalic());
        if (font != this.localFont) {
            if (this.localFont != null) {
                FontCache.checkIn(this.localFont);
            }
            this.localFont = font;
            this.getFigure().setFont(font);
        } else {
            FontCache.checkIn(font);
        }
        this.getTextFlow().setText(textRun.getText());
    }

    protected void searchColumn(CaretRequest search, SearchResult result) {
        TextFlow flow = this.getTextFlow();
        result.trailing = search.isForward;
        if (search.isRecursive || !(this.getParent() instanceof TextEditPart)) {
            if (search.isInto) {
                boolean bl = result.trailing = !search.isForward;
                result.location = search.isForward ? new TextLocation(this, flow.getNextVisibleOffset(-1)) : new TextLocation(this, flow.getPreviousVisibleOffset(-1));
            } else if (this.getLength() > 0) {
                result.location = search.isForward ? new TextLocation(this, flow.getNextVisibleOffset(0)) : new TextLocation(this, flow.getPreviousVisibleOffset(flow.getPreviousVisibleOffset(-1)));
            }
        } else if (search.isForward && search.where.offset < this.getLength()) {
            result.location = new TextLocation(this, flow.getNextVisibleOffset(search.where.offset));
        } else if (!search.isForward && search.where.offset > 0) {
            result.location = new TextLocation(this, flow.getPreviousVisibleOffset(search.where.offset));
        } else {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchLineBoundary(CaretRequest search, SearchResult result) {
        if (search.isRecursive || !(this.getParent() instanceof TextEditPart)) {
            int offset;
            Point where = search.getLocation().getCopy();
            TextFlow flow = this.getTextFlow();
            flow.translateToRelative((Translatable)where);
            result.trailing = search.isForward;
            if (search.isForward) {
                offset = flow.getLastOffsetForLine(where.y);
                if (offset != -1) {
                    ++offset;
                }
            } else {
                offset = flow.getFirstOffsetForLine(where.y);
            }
            if (offset != -1) {
                result.location = new TextLocation(this, offset);
            }
        } else {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchLocation(CaretRequest search, SearchResult result) {
        Point pt = search.getLocation().getCopy();
        this.getTextFlow().translateToRelative((Translatable)pt);
        if (result.location != null && this.vDistanceBetween(this.getTextFlow().getBounds(), pt.y) > result.proximity.height) {
            result.bestMatchFound = true;
            return;
        }
        int[] trailing = new int[1];
        int offset = this.getTextFlow().getOffset(pt, trailing, result.proximity) + trailing[0];
        if (offset != -1) {
            result.trailing = trailing[0] == 1;
            result.location = new TextLocation(this, offset);
            boolean bl = result.bestMatchFound = result.proximity.width == 0 && result.proximity.height == 0;
            if (result.bestMatchFound) {
                return;
            }
        }
        if (!search.isRecursive && this.getParent() instanceof TextEditPart) {
            search.setReferenceTextLocation(this, search.isForward ? this.getLength() : 0);
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchRow(CaretRequest search, SearchResult result) {
        if (search.isRecursive || !(this.getParent() instanceof TextEditPart)) {
            Point where = search.getLocation().getCopy();
            TextFlow flow = this.getTextFlow();
            flow.translateToRelative((Translatable)where);
            int[] trailing = new int[1];
            int offset = flow.getNextOffset(where, search.isForward, trailing) + trailing[0];
            if (offset != -1) {
                CaretInfo info = this.getCaretPlacement(offset, trailing[0] == 1);
                int vDistance = Math.abs(info.getBaseline() - search.getLocation().y);
                if (vDistance > result.proximity.height) {
                    result.bestMatchFound = true;
                } else {
                    int hDistance = Math.abs(info.getX() - search.getLocation().x);
                    if (vDistance < result.proximity.height || vDistance == result.proximity.height && hDistance < result.proximity.width) {
                        result.trailing = trailing[0] == 1;
                        result.location = new TextLocation(this, offset);
                        result.proximity.width = hDistance;
                        result.proximity.height = vDistance;
                    }
                }
            }
        } else {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchWordBoundary(CaretRequest search, SearchResult result) {
        String text = this.getTextFlow().getText();
        if (text.trim().length() > 0) {
            int length = text.length();
            int offset = -1;
            if (wordIterator == null) {
                wordIterator = BreakIterator.getWordInstance();
            }
            wordIterator.setText(text);
            offset = search.isRecursive ? (search.isForward ? 0 : length) : (search.isForward ? (search.where.offset == length ? -1 : wordIterator.following(search.where.offset)) : wordIterator.preceding(Math.min(search.where.offset, length - 1)));
            int index = Math.min(offset, length - 1);
            if (offset != -1 && Character.isWhitespace(text.charAt(index))) {
                int n = offset = search.isForward ? wordIterator.following(index) : wordIterator.preceding(index);
            }
            if (offset != -1) {
                result.location = new TextLocation(this, offset);
                result.trailing = offset == length;
                boolean bl = result.bestMatchFound = !Character.isWhitespace(text.charAt(Math.min(offset, length - 1)));
            }
        }
        if (!result.bestMatchFound && !search.isRecursive && this.getParent() instanceof TextEditPart) {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    public void setSelection(int start, int end) {
        if (start == end) {
            this.getTextFlow().setSelection(-1, -1);
        } else {
            this.getTextFlow().setSelection(start, end);
        }
    }

    private int vDistanceBetween(Rectangle rect, int y) {
        if (y < rect.y) {
            return rect.y - y;
        }
        return Math.max(0, y - rect.bottom());
    }
}

