/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.ui.launching;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.viewers.ClassesViewer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CoverageTab
extends AbstractLaunchConfigurationTab {
    private final boolean inplaceonly;
    private ClassesViewer classesviewer;
    private Button buttonInplaceInstrumentation;

    public CoverageTab(boolean inplaceonly) {
        this.inplaceonly = inplaceonly;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        ContextHelp.setHelp((Control)parent, "com.mountainminds.eclemma.ui.coverage_launch_tab_context");
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.setControl((Control)parent);
        this.createInstrumentedClasses(parent);
    }

    private void createInstrumentedClasses(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setText(UIMessages.CoverageTabInstrumentedClassesGroup_label);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.classesviewer = new ClassesViewer((Composite)group, 2048);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.classesviewer.getTable().setLayoutData((Object)gd);
        this.classesviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CoverageTab.this.setDirty(true);
                CoverageTab.this.updateErrorStatus();
                CoverageTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonInplaceInstrumentation = new Button((Composite)group, 32);
        this.buttonInplaceInstrumentation.setText(UIMessages.CoverageTabInplaceInstrumentation_label);
        this.buttonInplaceInstrumentation.setEnabled(!this.inplaceonly);
        this.buttonInplaceInstrumentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageTab.this.classesviewer.setIncludeBinaries(!CoverageTab.this.buttonInplaceInstrumentation.getSelection());
                CoverageTab.this.setDirty(true);
                CoverageTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonInplaceInstrumentation.setLayoutData((Object)new GridData(512));
        Button buttonSelectAll = this.createPushButton((Composite)group, UIMessages.SelectAllAction_label, null);
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageTab.this.classesviewer.selectAll();
                CoverageTab.this.setDirty(true);
                CoverageTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button buttonDeselectAll = this.createPushButton((Composite)group, UIMessages.DeselectAllAction_label, null);
        buttonDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageTab.this.classesviewer.deselectAll();
                CoverageTab.this.setDirty(true);
                CoverageTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean inplace = this.inplaceonly || configuration.getAttribute("com.mountainminds.eclemma.core.INPLACE_INSTRUMENTATION", false);
            this.buttonInplaceInstrumentation.setSelection(inplace);
            this.classesviewer.setIncludeBinaries(!inplace);
            this.classesviewer.setInput(CoverageTools.getClassFiles((ILaunchConfiguration)configuration, (boolean)true));
            this.classesviewer.setSelectedClasses(CoverageTools.getClassFilesForInstrumentation((ILaunchConfiguration)configuration, (boolean)inplace));
        }
        catch (CoreException e) {
            EclEmmaUIPlugin.log(e);
        }
        this.updateErrorStatus();
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            configuration.setAttribute("com.mountainminds.eclemma.core.INPLACE_INSTRUMENTATION", this.buttonInplaceInstrumentation.getSelection());
            IClassFiles[] classes = this.classesviewer.getSelectedClasses();
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < classes.length) {
                l.add(classes[i].getLocation().toString());
                ++i;
            }
            configuration.setAttribute("com.mountainminds.eclemma.core.INSTRUMENTATION_PATHS", l);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return !this.classesviewer.getSelection().isEmpty();
    }

    public String getName() {
        return UIMessages.CoverageTab_title;
    }

    public Image getImage() {
        return EclEmmaUIPlugin.getImage("icons/full/eview16/coverage.gif");
    }

    private void updateErrorStatus() {
        if (this.classesviewer.getSelection().isEmpty()) {
            this.setErrorMessage(UIMessages.CoverageTabNoClassesSelected_message);
        } else {
            this.setErrorMessage(null);
        }
    }
}

