/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.viewers;

import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ClassesViewer
implements ISelectionProvider {
    private final Table table;
    private final CheckboxTableViewer viewer;
    private final List listeners = new ArrayList();
    private IClassFiles[] input;
    private boolean includebinaries;
    private final Set selectedclasses = new HashSet();

    private static String getPathLabel(IPackageFragmentRoot root) {
        IPath path = root.getPath();
        if (!root.isExternal()) {
            path = path.removeFirstSegments(1);
        }
        return path.toString();
    }

    public ClassesViewer(Composite parent, int style) {
        this(new Table(parent, 0x20 | style));
    }

    public ClassesViewer(Table table) {
        this.table = table;
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageFragmentRootLabelProvider());
        this.viewer.setSorter((ViewerSorter)new PackageFragmentRootSorter());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ClassesViewer.this.updateCheckedStatus(event.getElement(), event.getChecked());
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public void setInput(IClassFiles[] input) {
        this.input = input;
        this.viewer.setInput((Object)this.getPackageFragmentRoots(input));
    }

    public void setIncludeBinaries(boolean includebinaries) {
        this.includebinaries = includebinaries;
        if (!includebinaries) {
            Iterator i = this.selectedclasses.iterator();
            while (i.hasNext()) {
                if (!((IClassFiles)i.next()).isBinary()) continue;
                i.remove();
            }
        }
        if (this.input != null) {
            this.viewer.setInput((Object)this.getPackageFragmentRoots(this.input));
        }
    }

    public void setSelectedClasses(IClassFiles[] classfiles) {
        this.selectedclasses.clear();
        this.selectedclasses.addAll(Arrays.asList(classfiles));
        this.viewer.setCheckedElements((Object[])this.getPackageFragmentRoots(classfiles));
    }

    public void setSelectedClasses(String[] locations) {
        HashSet<String> lset = new HashSet<String>(Arrays.asList(locations));
        this.selectedclasses.clear();
        int i = 0;
        while (i < this.input.length) {
            if (lset.contains(this.input[i].getLocation().toString())) {
                this.selectedclasses.add(this.input[i]);
            }
            ++i;
        }
        this.viewer.setCheckedElements((Object[])this.getPackageFragmentRoots(this.selectedclasses.toArray()));
    }

    public void selectAll() {
        this.selectedclasses.clear();
        int i = 0;
        while (i < this.input.length) {
            if (this.includebinaries || !this.input[i].isBinary()) {
                this.selectedclasses.add(this.input[i]);
            }
            ++i;
        }
        this.viewer.setCheckedElements((Object[])this.getPackageFragmentRoots(this.selectedclasses.toArray()));
    }

    public void deselectAll() {
        this.selectedclasses.clear();
        this.viewer.setCheckedElements(new Object[0]);
    }

    public IClassFiles[] getSelectedClasses() {
        return this.selectedclasses.toArray(new IClassFiles[0]);
    }

    public String[] getSelectedClassesLocations() {
        String[] locs = new String[this.selectedclasses.size()];
        int idx = 0;
        Iterator i = this.selectedclasses.iterator();
        while (i.hasNext()) {
            locs[idx++] = ((IClassFiles)i.next()).getLocation().toString();
        }
        return locs;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(Object[] classfiles) {
        HashSet<IPackageFragmentRoot> roots = new HashSet<IPackageFragmentRoot>();
        int i = 0;
        while (i < classfiles.length) {
            IClassFiles cf = (IClassFiles)classfiles[i];
            if (this.includebinaries || !cf.isBinary()) {
                roots.addAll(Arrays.asList(cf.getPackageFragmentRoots()));
            }
            ++i;
        }
        return roots.toArray(new IPackageFragmentRoot[roots.size()]);
    }

    private void updateCheckedStatus(Object root, boolean checked) {
        int i = 0;
        while (i < this.input.length) {
            IClassFiles cf = this.input[i];
            if (Arrays.asList(cf.getPackageFragmentRoots()).contains(root)) {
                if (checked) {
                    this.selectedclasses.add(cf);
                    break;
                }
                this.selectedclasses.remove(cf);
                break;
            }
            ++i;
        }
        this.viewer.setCheckedElements((Object[])this.getPackageFragmentRoots(this.selectedclasses.toArray()));
        this.fireSelectionEvent();
    }

    private void fireSelectionEvent() {
        SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(evt);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object[])this.getSelectedClasses());
    }

    public void setSelection(ISelection selection) {
        Object[] classfiles = ((IStructuredSelection)selection).toArray();
        this.selectedclasses.clear();
        this.selectedclasses.addAll(Arrays.asList(classfiles));
        this.viewer.setCheckedElements((Object[])this.getPackageFragmentRoots(classfiles));
    }

    private static class PackageFragmentRootLabelProvider
    extends LabelProvider {
        private ILabelProvider delegate = new WorkbenchLabelProvider();

        private PackageFragmentRootLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.delegate.getImage(element);
        }

        public String getText(Object element) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            String projectname = root.getJavaProject().getElementName();
            String path = ClassesViewer.getPathLabel(root);
            if (path.length() > 0) {
                String fmt = UIMessages.ClassesViewerEntry_label;
                return NLS.bind((String)fmt, (Object)projectname, (Object)ClassesViewer.getPathLabel(root));
            }
            return projectname;
        }

        public void dispose() {
            this.delegate.dispose();
        }
    }

    private static class PackageFragmentRootSorter
    extends ViewerSorter {
        private PackageFragmentRootSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IPackageFragmentRoot root1 = (IPackageFragmentRoot)e1;
            IPackageFragmentRoot root2 = (IPackageFragmentRoot)e2;
            int result = this.getCollator().compare(root1.getJavaProject().getElementName(), root2.getJavaProject().getElementName());
            if (result != 0) {
                return result;
            }
            if (root1.isExternal() != root2.isExternal()) {
                return root1.isExternal() ? 1 : -1;
            }
            return this.getCollator().compare(ClassesViewer.getPathLabel(root1), ClassesViewer.getPathLabel(root2));
        }
    }
}

