/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.dialogs;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CoveragePropertyPage
extends PropertyPage {
    private static final int COLUMN_COUNTER = 0;
    private static final int COLUMN_COVERAGE = 1;
    private static final int COLUMN_COVERED = 2;
    private static final int COLUMN_MISSED = 3;
    private static final int COLUMN_TOTAL = 4;
    private static final DecimalFormat COVERAGE_VALUE = new DecimalFormat(UIMessages.CoveragePropertyPageColumnCoverage_value);

    protected Control createContents(Composite parent) {
        ContextHelp.setHelp((Control)parent, "com.mountainminds.eclemma.ui.coverage_properties_context");
        this.noDefaultAndApplyButton();
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Label l1 = new Label(parent, 0);
        l1.setText(UIMessages.CoveragePropertyPageSession_label);
        l1.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text t1 = new Text(parent, 72);
        t1.setText(this.getSessionDescription());
        t1.setLayoutData((Object)new GridData(16384, 128, true, false));
        Control table = this.createTable(parent);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        return parent;
    }

    private String getSessionDescription() {
        ICoverageSession session = CoverageTools.getSessionManager().getActiveSession();
        return session == null ? UIMessages.CoveragePropertyPageNoSession_value : session.getDescription();
    }

    private Control createTable(Composite parent) {
        Table table = new Table(parent, 2048);
        this.initializeDialogUnits((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(table, 16384, 24, UIMessages.CoveragePropertyPageColumnCounter_label);
        this.createColumn(table, 131072, 16, UIMessages.CoveragePropertyPageColumnCoverage_label);
        this.createColumn(table, 131072, 16, UIMessages.CoveragePropertyPageColumnCovered_label);
        this.createColumn(table, 131072, 16, UIMessages.CoveragePropertyPageColumnMissed_label);
        this.createColumn(table, 131072, 16, UIMessages.CoveragePropertyPageColumnTotal_label);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((Line)element).counter.getTotalCount() != 0L;
            }
        });
        viewer.setInput((Object)this.getLines());
        viewer.setLabelProvider((IBaseLabelProvider)new CounterLabelProvider());
        return table;
    }

    private void createColumn(Table table, int align, int width, String caption) {
        TableColumn column = new TableColumn(table, align);
        column.setText(caption);
        column.setWidth(this.convertWidthInCharsToPixels(width));
    }

    private Line[] getLines() {
        IJavaElementCoverage c = CoverageTools.getCoverageInfo((Object)this.getElement());
        if (c == null) {
            return new Line[0];
        }
        return new Line[]{new Line(UIMessages.CoveragePropertyPageInstructions_label, c.getInstructionCounter()), new Line(UIMessages.CoveragePropertyPageBlocks_label, c.getBlockCounter()), new Line(UIMessages.CoveragePropertyPageLines_label, c.getLineCounter()), new Line(UIMessages.CoveragePropertyPageMethods_label, c.getMethodCounter()), new Line(UIMessages.CoveragePropertyPageTypes_label, c.getTypeCounter())};
    }

    private static class CounterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CounterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Line l = (Line)element;
                return EclEmmaUIPlugin.getCoverageImage(l.counter.getRatio());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Line l = (Line)element;
            switch (columnIndex) {
                case 0: {
                    return l.label;
                }
                case 1: {
                    return COVERAGE_VALUE.format(l.counter.getRatio());
                }
                case 2: {
                    return String.valueOf(l.counter.getCoveredCount());
                }
                case 3: {
                    return String.valueOf(l.counter.getMissedCount());
                }
                case 4: {
                    return String.valueOf(l.counter.getTotalCount());
                }
            }
            return "";
        }
    }

    private static class Line {
        public final String label;
        public final ICounter counter;

        public Line(String label, ICounter counter) {
            this.label = label;
            this.counter = counter;
        }
    }
}

