/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

class CopyAction
extends SelectionProviderAction {
    private final Display display;
    private final ViewSettings settings;
    private final ITableLabelProvider labelprovider;
    private final ISelectionProvider selectionSource;

    public CopyAction(Display display, ViewSettings settings, ITableLabelProvider labelprovider, ISelectionProvider selectionSource) {
        super(selectionSource, UIMessages.CopyAction_label);
        this.display = display;
        this.settings = settings;
        this.labelprovider = labelprovider;
        this.selectionSource = selectionSource;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }

    public void run() {
        StringBuffer sb = new StringBuffer();
        String[] headers = this.settings.getCounterMode().getColumnHeaders();
        sb.append(headers[0]).append('\t');
        sb.append(headers[1]).append('\t');
        sb.append(headers[2]).append('\t');
        sb.append(headers[3]).append('\t');
        sb.append(headers[4]).append(Text.DELIMITER);
        for (Object element : (IStructuredSelection)this.selectionSource.getSelection()) {
            this.appendColumn(sb, element, 0).append('\t');
            this.appendColumn(sb, element, 1).append('\t');
            this.appendColumn(sb, element, 2).append('\t');
            this.appendColumn(sb, element, 3).append('\t');
            this.appendColumn(sb, element, 4).append(Text.DELIMITER);
        }
        this.copy(sb.toString());
    }

    private final StringBuffer appendColumn(StringBuffer sb, Object element, int column) {
        sb.append(this.labelprovider.getColumnText(element, column));
        return sb;
    }

    private void copy(String text) {
        Clipboard cb = new Clipboard(this.display);
        TextTransfer transfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text}, new Transfer[]{transfer});
        cb.dispose();
    }
}

