/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.annotation;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.analysis.IJavaCoverageListener;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.core.analysis.ILineCoverage;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.annotation.CoverageAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CoverageAnnotationModel
implements IAnnotationModel {
    private static final Object KEY = new Object();
    private List annotations = new ArrayList(32);
    private List annotationModelListeners = new ArrayList(2);
    private final ITextEditor editor;
    private final IDocument document;
    private int openConnections = 0;
    private boolean annotated = false;
    private IJavaCoverageListener coverageListener = new IJavaCoverageListener(){

        public void coverageChanged() {
            CoverageAnnotationModel.this.updateAnnotations(true);
        }
    };
    private IDocumentListener documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            CoverageAnnotationModel.this.updateAnnotations(false);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    private CoverageAnnotationModel(ITextEditor editor, IDocument document) {
        this.editor = editor;
        this.document = document;
        this.updateAnnotations(true);
    }

    public static void attach(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (!(model instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        CoverageAnnotationModel coveragemodel = (CoverageAnnotationModel)modelex.getAnnotationModel(KEY);
        if (coveragemodel == null) {
            coveragemodel = new CoverageAnnotationModel(editor, document);
            modelex.addAnnotationModel(KEY, (IAnnotationModel)coveragemodel);
        }
    }

    public static void detach(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (!(model instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
        modelex.removeAnnotationModel(KEY);
    }

    protected void updateAnnotations(boolean force) {
        Object element;
        IEditorInput input;
        ILineCoverage lineCoverage = null;
        boolean annotate = false;
        if (!this.editor.isDirty() && (input = this.editor.getEditorInput()) != null && (lineCoverage = this.findLineCoverage(element = input.getAdapter(IJavaElement.class))) != null && this.hasSource((IJavaElement)element)) {
            annotate = true;
        }
        if (annotate) {
            if (!this.annotated || force) {
                this.createAnnotations(lineCoverage);
                this.annotated = true;
            }
        } else if (this.annotated) {
            this.clear();
            this.annotated = false;
        }
    }

    protected boolean hasSource(IJavaElement element) {
        if (element instanceof ISourceReference) {
            try {
                return ((ISourceReference)element).getSourceRange() != null;
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    protected ILineCoverage findLineCoverage(Object element) {
        IJavaElementCoverage coverage = CoverageTools.getCoverageInfo((Object)element);
        if (coverage == null) {
            return null;
        }
        IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
        if (resource != null && resource.getModificationStamp() != coverage.getResourceModificationStamp()) {
            return null;
        }
        return coverage.getLineCoverage();
    }

    protected void clear() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
    }

    protected void clear(AnnotationModelEvent event) {
        for (CoverageAnnotation ca : this.annotations) {
            event.annotationRemoved((Annotation)ca, ca.getPosition());
        }
        this.annotations.clear();
    }

    protected void createAnnotations(ILineCoverage linecoverage) {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        int firstline = linecoverage.getFirstLine();
        int lastline = linecoverage.getLastLine();
        int offset = linecoverage.getOffset();
        byte[] coverage = linecoverage.getCoverage();
        try {
            int l = firstline;
            while (l <= lastline) {
                byte status = coverage[l - offset];
                if (status != 0) {
                    IRegion region = this.document.getLineInformation(l - 1);
                    int docoffset = region.getOffset();
                    int doclength = region.getLength();
                    while (l < lastline && coverage[l + 1 - offset] == status) {
                        region = this.document.getLineInformation(++l - 1);
                        doclength = region.getOffset() - docoffset + region.getLength();
                    }
                    CoverageAnnotation ca = new CoverageAnnotation(docoffset, doclength, status);
                    this.annotations.add(ca);
                    event.annotationAdded((Annotation)ca);
                }
                ++l;
            }
        }
        catch (BadLocationException ex) {
            EclEmmaUIPlugin.log(ex);
        }
        this.fireModelChanged(event);
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.annotationModelListeners.contains(listener)) {
            this.annotationModelListeners.add(listener);
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this, true));
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.annotationModelListeners.remove(listener);
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        event.markSealed();
        if (!event.isEmpty()) {
            for (IAnnotationModelListener l : this.annotationModelListeners) {
                if (l instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)l).modelChanged(event);
                    continue;
                }
                l.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public void connect(IDocument document) {
        if (this.document != document) {
            throw new RuntimeException("Can't connect to different document.");
        }
        for (CoverageAnnotation ca : this.annotations) {
            try {
                document.addPosition(ca.getPosition());
            }
            catch (BadLocationException ex) {
                EclEmmaUIPlugin.log(ex);
            }
        }
        if (this.openConnections++ == 0) {
            CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
            document.addDocumentListener(this.documentListener);
        }
    }

    public void disconnect(IDocument document) {
        if (this.document != document) {
            throw new RuntimeException("Can't disconnect from different document.");
        }
        for (CoverageAnnotation ca : this.annotations) {
            document.removePosition(ca.getPosition());
        }
        if (--this.openConnections == 0) {
            CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
            document.removeDocumentListener(this.documentListener);
        }
    }

    public void addAnnotation(Annotation annotation, Position position) {
        throw new UnsupportedOperationException();
    }

    public void removeAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException();
    }

    public Iterator getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public Position getPosition(Annotation annotation) {
        if (annotation instanceof CoverageAnnotation) {
            return ((CoverageAnnotation)annotation).getPosition();
        }
        return null;
    }
}

