/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.ILazyBinding;
import com.mountainminds.eclemma.internal.core.analysis.JavaElementCoverage;
import com.mountainminds.eclemma.internal.core.analysis.JavaModelCoverage;
import com.mountainminds.eclemma.internal.core.analysis.MethodLocator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeCoverage
extends JavaElementCoverage
implements ILazyBinding {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private UnboundMethodCoverage[] ubmethods = null;

    public TypeCoverage(JavaElementCoverage parent, boolean haslines, long stamp) {
        super(parent, haslines, stamp);
    }

    public TypeCoverage(JavaElementCoverage parent, boolean haslines, IResource resource) {
        super(parent, haslines, resource);
    }

    public void setUnboundMethods(UnboundMethodCoverage[] ubmethods) {
        this.ubmethods = ubmethods;
    }

    @Override
    public void resolve(IJavaElement element, JavaModelCoverage modelcoverage) {
        if (this.ubmethods != null) {
            IType type = (IType)element;
            try {
                MethodLocator locator = new MethodLocator(type);
                int i = 0;
                while (i < this.ubmethods.length) {
                    String name = this.ubmethods[i].name;
                    String signature = this.ubmethods[i].signature;
                    IMethod method = locator.findMethod(name, signature);
                    if (method != null) {
                        modelcoverage.put((IJavaElement)method, this.ubmethods[i].coverage);
                    } else {
                        TRACER.trace("Method not found in Java model: {0}.{1}{2}", type.getFullyQualifiedName(), name, signature);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                TRACER.trace("Error while creating method locator for {0}: {1}", type.getFullyQualifiedName(), (Object)e);
            }
            this.ubmethods = null;
        }
    }

    public static class UnboundMethodCoverage {
        final String name;
        final String signature;
        final IJavaElementCoverage coverage;

        UnboundMethodCoverage(String name, String signature, IJavaElementCoverage coverage) {
            this.name = name;
            this.signature = signature;
            this.coverage = coverage;
        }
    }
}

