/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.ISessionExporter;
import com.mountainminds.eclemma.core.ISourceLocation;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.report.ReportProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class SessionExporter
implements ISessionExporter {
    private static final String PROP_OUT_FILE = "report.out.file";
    private static final String PROP_OUT_ENCODING = "report.out.encoding";
    private static final String OUTPUT_ENCODING = "UTF-8";
    private final ICoverageSession session;
    private int format;
    private String destination;
    private Properties options;

    public SessionExporter(ICoverageSession session) {
        this.session = session;
    }

    @Override
    public void setFormat(int format) {
        this.format = format;
    }

    @Override
    public void setDestination(String filename) {
        this.destination = filename;
    }

    @Override
    public void setReportOptions(Properties options) {
        this.options = options;
    }

    @Override
    public void export(IProgressMonitor monitor) throws CoreException {
        if (this.format == 3) {
            this.createSessionFile(monitor);
        } else {
            this.createReport(monitor);
        }
    }

    private void createReport(IProgressMonitor monitor) throws CoreException {
        IInstrumentation[] instrs = this.session.getInstrumentations();
        IPath[] coveragefiles = this.session.getCoverageDataFiles();
        monitor.beginTask(NLS.bind((String)CoreMessages.ExportingSession_task, (Object)this.session.getDescription()), instrs.length + coveragefiles.length + 1);
        ArrayList<String> datapath = new ArrayList<String>();
        ArrayList<String> sourcepath = new ArrayList<String>();
        int i = 0;
        while (i < instrs.length) {
            if (instrs[i].getMetaDataFile().toFile().exists()) {
                datapath.add(instrs[i].getMetaDataFile().toOSString());
                if (this.format == 0) {
                    ISourceLocation[] srcs = instrs[i].getClassFiles().getSourceLocations();
                    SubProgressMonitor srcmonitor = new SubProgressMonitor(monitor, 1);
                    srcmonitor.beginTask("", srcs.length);
                    int j = 0;
                    while (j < srcs.length) {
                        srcs[j].extract((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)srcmonitor, 1));
                        sourcepath.add(srcs[j].getPath().toOSString());
                        ++j;
                    }
                    srcmonitor.done();
                } else {
                    monitor.worked(1);
                }
            } else {
                monitor.worked(1);
            }
            ++i;
        }
        i = 0;
        while (i < coveragefiles.length) {
            datapath.add(coveragefiles[i].toOSString());
            monitor.worked(1);
            ++i;
        }
        ReportProcessor processor = ReportProcessor.create();
        processor.setDataPath(datapath.toArray(new String[0]));
        processor.setSourcePath(sourcepath.toArray(new String[0]));
        processor.setReportTypes(new String[]{DEFAULT_EXTENSIONS[this.format]});
        Properties props = new Properties(this.options);
        props.setProperty(PROP_OUT_FILE, this.destination);
        props.setProperty(PROP_OUT_ENCODING, OUTPUT_ENCODING);
        processor.setPropertyOverrides(props);
        processor.run();
        monitor.done();
    }

    private void createSessionFile(IProgressMonitor monitor) throws CoreException {
        IInstrumentation[] instrs = this.session.getInstrumentations();
        IPath[] coveragefiles = this.session.getCoverageDataFiles();
        monitor.beginTask(NLS.bind((String)CoreMessages.ExportingSession_task, (Object)this.session.getDescription()), instrs.length + coveragefiles.length + 1);
        IMergeable metadata = null;
        int i = 0;
        while (i < instrs.length) {
            metadata = this.loadDataFile(metadata, 0, instrs[i].getMetaDataFile());
            monitor.worked(1);
            ++i;
        }
        IMergeable coveragedata = null;
        int i2 = 0;
        while (i2 < coveragefiles.length) {
            coveragedata = this.loadDataFile(coveragedata, 1, coveragefiles[i2]);
            monitor.worked(1);
            ++i2;
        }
        SessionData sessiondata = new SessionData((IMetaData)metadata, (ICoverageData)coveragedata);
        try {
            DataFactory.persist((ISessionData)sessiondata, (File)new File(this.destination), (boolean)false);
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.COVERAGEDATA_FILE_READ_ERROR.getStatus(this.destination, e));
        }
        monitor.done();
    }

    private IMergeable loadDataFile(IMergeable data, int type, IPath path) throws CoreException {
        try {
            File f = path.toFile();
            if (f.exists()) {
                IMergeable newdata = DataFactory.load((File)f)[type];
                data = data == null ? newdata : data.merge(newdata);
            }
            return data;
        }
        catch (IOException e) {
            if (type == 1) {
                throw new CoreException(EclEmmaStatus.COVERAGEDATA_FILE_READ_ERROR.getStatus(path, e));
            }
            throw new CoreException(EclEmmaStatus.METADATA_FILE_READ_ERROR.getStatus(path, e));
        }
    }
}

