/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IInstrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CoverageSession
extends PlatformObject
implements ICoverageSession {
    private final String description;
    private final IInstrumentation[] instrumentations;
    private final IPath[] coveragedatafiles;
    private final ILaunchConfiguration launchconfiguration;

    public CoverageSession(String description, IInstrumentation[] instrumentations, IPath[] coveragedatafiles, ILaunchConfiguration launchconfiguration) {
        this.description = description;
        this.instrumentations = instrumentations;
        this.coveragedatafiles = coveragedatafiles;
        this.launchconfiguration = launchconfiguration;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IInstrumentation[] getInstrumentations() {
        return this.instrumentations;
    }

    @Override
    public IPath[] getCoverageDataFiles() {
        return this.coveragedatafiles;
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchconfiguration;
    }

    @Override
    public ICoverageSession merge(ICoverageSession other, String description) {
        List i = this.merge(this.instrumentations, other.getInstrumentations());
        List c = this.merge(this.coveragedatafiles, other.getCoverageDataFiles());
        return new CoverageSession(description, i.toArray(new IInstrumentation[i.size()]), c.toArray(new IPath[c.size()]), this.launchconfiguration);
    }

    private List merge(Object[] arr1, Object[] arr2) {
        ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(arr1));
        int i = 0;
        while (i < arr2.length) {
            if (!l.contains(arr2[i])) {
                l.add(arr2[i]);
            }
            ++i;
        }
        return l;
    }
}

