/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core.launching;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.core.launching.ICoverageLauncher;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.instr.InstrMarker;
import com.mountainminds.eclemma.internal.core.launching.CoverageLaunchInfo;
import com.mountainminds.eclemma.internal.core.launching.InstrumentedClasspathProvider;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class CoverageLauncher
implements ICoverageLauncher,
IExecutableExtension {
    protected static final String EMMA_PROPERTIES_FILE = "emma.properties";
    public static final String DELEGATELAUNCHMODE = "run";
    protected String launchtype;
    protected ILaunchConfigurationDelegate launchdelegate;
    protected ILaunchConfigurationDelegate2 launchdelegate2;

    protected void modifyConfiguration(ILaunchConfigurationWorkingCopy workingcopy, ICoverageLaunchInfo info) throws CoreException {
    }

    protected boolean hasInplaceInstrumentation(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("com.mountainminds.eclemma.core.INPLACE_INSTRUMENTATION", false);
    }

    private void createPropertiesJAR(ILaunchConfiguration configuration, ICoverageLaunchInfo info) throws CoreException {
        Properties properties = new Properties();
        properties.put("coverage.out.file", info.getCoverageFile().toOSString());
        properties.put("verbosity.level", DebugOptions.EMMAVERBOSITYLEVEL);
        IPath jarfile = info.getPropertiesJARFile();
        Manifest mf = new Manifest();
        try {
            JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(jarfile.toFile()), mf);
            jar.putNextEntry(new ZipEntry(EMMA_PROPERTIES_FILE));
            properties.store(jar, "Created for launch configuration " + configuration.getName());
            jar.close();
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.EMMA_PROPERTIES_CREATION_ERROR.getStatus(jarfile, e));
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.launchtype = config.getAttribute("type");
        this.launchdelegate = this.getLaunchDelegate(this.launchtype);
        if (this.launchdelegate instanceof ILaunchConfigurationDelegate2) {
            this.launchdelegate2 = (ILaunchConfigurationDelegate2)this.launchdelegate;
        }
    }

    private ILaunchConfigurationDelegate getLaunchDelegate(String launchtype) throws CoreException {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchtype);
        if (type == null) {
            throw new CoreException(EclEmmaStatus.UNKOWN_LAUNCH_TYPE_ERROR.getStatus(launchtype));
        }
        return type.getDelegate(DELEGATELAUNCHMODE);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)CoreMessages.Launching_task, (Object)configuration.getName()), 2);
        IRuntimeClasspathProvider provider = JavaRuntime.getClasspathProvider((ILaunchConfiguration)configuration);
        ICoverageLaunchInfo info = CoverageTools.getLaunchInfo(launch);
        if (info == null) {
            throw new CoreException(EclEmmaStatus.MISSING_LAUNCH_INFO_ERROR.getStatus(null));
        }
        info.instrument((IProgressMonitor)new SubProgressMonitor(monitor, 1), this.hasInplaceInstrumentation(configuration));
        if (monitor.isCanceled()) {
            return;
        }
        this.createPropertiesJAR(configuration, info);
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        this.modifyConfiguration(wc, info);
        InstrumentedClasspathProvider.enable(provider, info);
        try {
            this.launchdelegate.launch((ILaunchConfiguration)wc, DELEGATELAUNCHMODE, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            InstrumentedClasspathProvider.disable();
        }
        monitor.done();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        Launch launch = new Launch(configuration, "coverage", null);
        new CoverageLaunchInfo((ILaunch)launch);
        return launch;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.buildForLaunch(configuration, DELEGATELAUNCHMODE, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean inplace = this.hasInplaceInstrumentation(configuration);
        if (CoverageTools.getClassFilesForInstrumentation(configuration, inplace).length == 0) {
            IStatus status = EclEmmaStatus.NO_INSTRUMENTED_CLASSES.getStatus();
            EclEmmaCorePlugin.getInstance().showPrompt(status, configuration);
            return false;
        }
        if (inplace) {
            IStatus status = EclEmmaStatus.INPLACE_INSTRUMENTATION_INFO.getStatus();
            if (!EclEmmaCorePlugin.getInstance().showPrompt(status, configuration)) {
                return false;
            }
        } else if (this.checkForPreviousInplace(configuration)) {
            IStatus status = EclEmmaStatus.ALREADY_INSTRUMENTED_ERROR.getStatus();
            EclEmmaCorePlugin.getInstance().showPrompt(status, configuration);
            return false;
        }
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.preLaunchCheck(configuration, DELEGATELAUNCHMODE, monitor);
    }

    private boolean checkForPreviousInplace(ILaunchConfiguration config) throws CoreException {
        IClassFiles[] classfiles = CoverageTools.getClassFilesForInstrumentation(config, false);
        int i = 0;
        while (i < classfiles.length) {
            if (InstrMarker.isMarked(classfiles[i].getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.finalLaunchCheck(configuration, DELEGATELAUNCHMODE, monitor);
    }

    @Override
    public IClassFiles[] getClassFiles(ILaunchConfiguration configuration, boolean includebinaries) throws CoreException {
        ArrayList<IClassFiles> l = new ArrayList<IClassFiles>();
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IClassFiles ic;
            if (entries[i].getClasspathProperty() == 3 && (ic = CoverageTools.getClassFilesAtAbsoluteLocation(entries[i].getLocation())) != null && (includebinaries || !ic.isBinary())) {
                l.add(ic);
            }
            ++i;
        }
        IClassFiles[] arr = new IClassFiles[l.size()];
        return l.toArray(arr);
    }

    protected IClassFiles findClassFiles(String location) throws CoreException {
        return CoverageTools.getClassFilesAtAbsoluteLocation(location);
    }
}

