/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.ICorePreferences;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.ISessionExporter;
import com.mountainminds.eclemma.core.ISessionImporter;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.core.analysis.IJavaCoverageListener;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.core.analysis.ILineCoverage;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.core.launching.ICoverageLauncher;
import com.mountainminds.eclemma.internal.core.CoverageSession;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.SessionExporter;
import com.mountainminds.eclemma.internal.core.SessionImporter;
import com.mountainminds.eclemma.internal.core.instr.DefaultInstrumentationFilter;
import com.mountainminds.eclemma.internal.core.launching.CoverageLaunchInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public final class CoverageTools {
    public static final String LAUNCH_MODE = "coverage";
    public static final int EXPORT_HTML = 0;
    public static final int EXPORT_XML = 1;
    public static final int EXPORT_TEXT = 2;
    public static final int EXPORT_ES = 3;

    public static ISessionManager getSessionManager() {
        return EclEmmaCorePlugin.getInstance().getSessionManager();
    }

    public static IJavaElementCoverage getCoverageInfo(Object object) {
        if (object instanceof IAdaptable) {
            return (IJavaElementCoverage)((IAdaptable)object).getAdapter(IJavaElementCoverage.class);
        }
        return null;
    }

    public static ILineCoverage getLineCoverage(Object object) {
        if (object instanceof IAdaptable) {
            return (ILineCoverage)((IAdaptable)object).getAdapter(ILineCoverage.class);
        }
        return null;
    }

    public static ICoverageLaunchInfo getLaunchInfo(ILaunch launch) {
        return CoverageLaunchInfo.getInfo(launch);
    }

    public static IPath getEmmaJar() throws CoreException {
        URL url = EclEmmaCorePlugin.getInstance().find(EclEmmaCorePlugin.EMMA_JAR);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.NO_LOCAL_EMMAJAR_ERROR.getStatus(e));
        }
        return new Path(url.getPath());
    }

    public static IClassFiles[] getClassFiles() throws CoreException {
        return EclEmmaCorePlugin.getInstance().getAllClassFiles().getClassFiles();
    }

    public static IClassFiles getClassFilesAtAbsoluteLocation(String location) throws CoreException {
        return EclEmmaCorePlugin.getInstance().getAllClassFiles().getAtAbsoluteLocation(location);
    }

    public static IClassFiles[] getClassFiles(ILaunchConfiguration configuration, boolean includebinaries) throws CoreException {
        ICoverageLauncher launcher = (ICoverageLauncher)configuration.getType().getDelegate(LAUNCH_MODE);
        return launcher.getClassFiles(configuration, includebinaries);
    }

    public static IClassFiles[] getClassFilesForInstrumentation(ILaunchConfiguration configuration, boolean inplace) throws CoreException {
        IClassFiles[] all = CoverageTools.getClassFiles(configuration, !inplace);
        List selection = configuration.getAttribute("com.mountainminds.eclemma.core.INSTRUMENTATION_PATHS", null);
        if (selection != null && selection.size() > 0) {
            ArrayList<IClassFiles> filtered = new ArrayList<IClassFiles>();
            int i = 0;
            while (i < all.length) {
                if (selection.contains(all[i].getLocation().toString())) {
                    filtered.add(all[i]);
                }
                ++i;
            }
            return filtered.toArray(new IClassFiles[filtered.size()]);
        }
        DefaultInstrumentationFilter filter = EclEmmaCorePlugin.getInstance().createDefaultIntrumentationFilter();
        return filter.filter(all, configuration);
    }

    public static ICoverageSession createCoverageSession(String description, IInstrumentation[] instrumentations, IPath[] coveragedatafiles, ILaunchConfiguration launchconfiguration) {
        return new CoverageSession(description, instrumentations, coveragedatafiles, launchconfiguration);
    }

    public static IJavaModelCoverage getJavaModelCoverage() {
        return EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().getJavaModelCoverage();
    }

    public static void addJavaCoverageListener(IJavaCoverageListener l) {
        EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().addJavaCoverageListener(l);
    }

    public static void removeJavaCoverageListener(IJavaCoverageListener l) {
        EclEmmaCorePlugin.getInstance().getJavaCoverageLoader().removeJavaCoverageListener(l);
    }

    public static ISessionExporter getExporter(ICoverageSession session) {
        return new SessionExporter(session);
    }

    public static ISessionImporter getImporter() {
        return new SessionImporter();
    }

    public static void setPreferences(ICorePreferences preferences) {
        EclEmmaCorePlugin.getInstance().setPreferences(preferences);
    }
}

