/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.instr;

import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.ISourceLocation;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.instr.InstrMarker;
import com.mountainminds.eclemma.internal.core.instr.Instrumentation;
import com.mountainminds.eclemma.internal.core.instr.SourceLocation;
import com.vladium.emma.instr.InstrProcessor;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class ClassFiles
implements IClassFiles {
    private static final DebugOptions.ITracer PERFORMANCE = DebugOptions.PERFORMANCETRACER;
    private static final String METADATAFILE_EXT = "em";
    private final IPackageFragmentRoot[] roots;
    private final IPath location;
    private final boolean binary;

    public ClassFiles(IPackageFragmentRoot root, IPath location) throws JavaModelException {
        this(new IPackageFragmentRoot[]{root}, location, root.getKind() == 2);
    }

    private ClassFiles(IPackageFragmentRoot[] roots, IPath location, boolean binary) {
        this.roots = roots;
        this.location = location;
        this.binary = binary;
    }

    public ClassFiles addRoot(IPackageFragmentRoot root) throws JavaModelException {
        IPackageFragmentRoot[] newroots = new IPackageFragmentRoot[this.roots.length + 1];
        System.arraycopy(this.roots, 0, newroots, 0, this.roots.length);
        newroots[this.roots.length] = root;
        return new ClassFiles(newroots, this.location, this.binary && root.getKind() == 2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[").append(this.location).append("]");
        return sb.toString();
    }

    public boolean isBinary() {
        return this.binary;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() {
        return this.roots;
    }

    public IPath getLocation() {
        return this.location;
    }

    public ISourceLocation[] getSourceLocations() throws JavaModelException {
        ArrayList<ISourceLocation> l = new ArrayList<ISourceLocation>();
        int i = 0;
        while (i < this.roots.length) {
            ISourceLocation location = SourceLocation.findLocation(this.roots[i]);
            if (location != null) {
                l.add(location);
            }
            ++i;
        }
        ISourceLocation[] array = new ISourceLocation[l.size()];
        return l.toArray(array);
    }

    public IInstrumentation instrument(boolean inplace, IProgressMonitor monitor) throws CoreException {
        PERFORMANCE.startTimer();
        monitor.beginTask(NLS.bind((String)CoreMessages.InstrumentingClassesIn_task, (Object)this.location), 1);
        IPath outputlocation = EclEmmaCorePlugin.getInstance().getStateFiles().getInstrDataFolder(this.location);
        outputlocation.toFile().mkdirs();
        IPath metadatafile = outputlocation.addFileExtension(METADATAFILE_EXT);
        if (inplace) {
            InstrMarker.mark(this.location);
            outputlocation = EclEmmaCorePlugin.getAbsolutePath(this.location);
        }
        InstrProcessor processor = InstrProcessor.create();
        processor.setInstrPath(new String[]{EclEmmaCorePlugin.getAbsolutePath(this.location).toOSString()}, true);
        processor.setInstrOutDir(outputlocation.toOSString());
        processor.setMetaOutFile(metadatafile.toOSString());
        processor.setMetaOutMerge(Boolean.TRUE);
        processor.setOutMode(inplace ? InstrProcessor.OutMode.OUT_MODE_OVERWRITE : InstrProcessor.OutMode.OUT_MODE_COPY);
        Properties props = new Properties();
        props.put("verbosity.level", DebugOptions.EMMAVERBOSITYLEVEL);
        processor.setPropertyOverrides(props);
        processor.run();
        monitor.done();
        PERFORMANCE.stopTimer("instrumenting " + this.location);
        return new Instrumentation(this, inplace, outputlocation, metadatafile);
    }
}

