/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class StateFiles {
    private static final String LAUNCHDATA_FOLDER = ".launch/";
    private static final String INSTRDATA_FOLDER = ".instr/";
    private static final String IMPORTDATA_FOLDER = ".import/";
    private static final String SOURCE_FOLDER = ".src/";
    private static final ReferenceQueue CLEANUPQUEUE = new ReferenceQueue();
    private static final Set CLEANUPFILES = new HashSet();
    private final IPath stateLocation;

    public StateFiles(IPath stateLocation) {
        this.stateLocation = stateLocation;
        this.stateLocation.toFile().mkdirs();
        this.getLaunchDataFolder().toFile().mkdirs();
        this.getInstrDataFolder().toFile().mkdirs();
        this.getSourceDataFolder().toFile().mkdirs();
        this.getImportDataFolder().toFile().mkdirs();
    }

    public void deleteTemporaryFiles() {
        StateFiles.deleteFiles(this.getLaunchDataFolder().toFile(), false);
        StateFiles.deleteFiles(this.getInstrDataFolder().toFile(), false);
        StateFiles.deleteFiles(this.getSourceDataFolder().toFile(), false);
        StateFiles.deleteFiles(this.getImportDataFolder().toFile(), false);
    }

    private static void deleteFiles(File file, boolean deleteparent) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                StateFiles.deleteFiles(files[i], true);
                ++i;
            }
        }
        if (deleteparent) {
            file.delete();
        }
    }

    public IPath getLaunchDataFolder() {
        return this.stateLocation.append(LAUNCHDATA_FOLDER);
    }

    private IPath getInstrDataFolder() {
        return this.stateLocation.append(INSTRDATA_FOLDER);
    }

    public IPath getInstrDataFolder(IPath location) throws CoreException {
        return this.getInstrDataFolder().append(StateFiles.getInternalId(location, false));
    }

    private IPath getSourceDataFolder() {
        return this.stateLocation.append(SOURCE_FOLDER);
    }

    public IPath getSourceFolder(IPath location) throws CoreException {
        return this.getSourceDataFolder().append(StateFiles.getInternalId(location, true));
    }

    private IPath getImportDataFolder() {
        return this.stateLocation.append(IMPORTDATA_FOLDER);
    }

    public IPath getImportSessionFile(IPath original) throws CoreException {
        IPath p = this.getImportDataFolder().append(StateFiles.getInternalId(original, true));
        this.registerForCleanup(p);
        return p;
    }

    private static String getInternalId(IPath location, boolean withtimestamp) throws CoreException {
        File f;
        long timestamp = 0L;
        if (withtimestamp && (f = location.toFile()).exists()) {
            timestamp = f.lastModified();
        }
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(location.toString().getBytes("UTF8"));
            md.update(Long.toHexString(timestamp).getBytes("UTF8"));
            byte[] sig = md.digest();
            int i = 0;
            while (i < sig.length) {
                sb.append(Character.forDigit(sig[i] >> 4 & 0xF, 16));
                sb.append(Character.forDigit(sig[i] & 0xF, 16));
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoreException(EclEmmaStatus.ID_CREATION_ERROR.getStatus(e));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException(EclEmmaStatus.ID_CREATION_ERROR.getStatus(e));
        }
        return sb.toString();
    }

    public void registerForCleanup(IPath file) {
        this.cleanupObsoleteFiles();
        CLEANUPFILES.add(new CleanupFile(file));
    }

    private void cleanupObsoleteFiles() {
        CleanupFile f;
        while ((f = (CleanupFile)CLEANUPQUEUE.poll()) != null) {
            CLEANUPFILES.remove(f);
            f.delete();
        }
    }

    private static class CleanupFile
    extends PhantomReference {
        private final File file;

        public CleanupFile(IPath path) {
            super(path, CLEANUPQUEUE);
            this.file = path.toFile();
        }

        public void delete() {
            StateFiles.deleteFiles(this.file, true);
            this.clear();
        }
    }
}

