/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.ICorePreferences;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.CoverageSession;
import com.mountainminds.eclemma.internal.core.JavaCoverageLoader;
import com.mountainminds.eclemma.internal.core.SessionManager;
import com.mountainminds.eclemma.internal.core.StateFiles;
import com.mountainminds.eclemma.internal.core.instr.ClassFilesStore;
import com.mountainminds.eclemma.internal.core.instr.DefaultInstrumentationFilter;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.BundleContext;

public class EclEmmaCorePlugin
extends Plugin {
    public static final String ID = "com.mountainminds.eclemma.core";
    private static final IStatus PROMPT_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    public static final IPath EMMA_JAR = new Path("/emma.jar");
    private static EclEmmaCorePlugin instance;
    private ICorePreferences preferences = ICorePreferences.DEFAULT;
    private ISessionManager sessionManager;
    private JavaCoverageLoader coverageLoader;
    private StateFiles stateFiles;
    private ClassFilesStore allClassFiles = null;
    private ILaunchListener launchListener = new ILaunchListener(){

        public void launchRemoved(ILaunch launch) {
            if (EclEmmaCorePlugin.this.preferences.getAutoRemoveSessions()) {
                EclEmmaCorePlugin.this.sessionManager.removeSession(launch);
            }
        }

        public void launchAdded(ILaunch launch) {
        }

        public void launchChanged(ILaunch launch) {
        }
    };
    private IDebugEventSetListener debugListener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                IProcess proc;
                ILaunch launch;
                ICoverageLaunchInfo info;
                DebugEvent e = events[i];
                if (e.getSource() instanceof IProcess && e.getKind() == 8 && (info = CoverageTools.getLaunchInfo(launch = (proc = (IProcess)e.getSource()).getLaunch())) != null) {
                    IPath coveragedatafile = info.getCoverageFile();
                    if (this.checkCoverageDataFile(coveragedatafile)) {
                        Object[] args = new Object[]{launch.getLaunchConfiguration().getName(), new Date()};
                        String description = MessageFormat.format(CoreMessages.LaunchSessionDescription_value, args);
                        CoverageSession session = new CoverageSession(description, info.getInstrumentations(), new IPath[]{coveragedatafile}, launch.getLaunchConfiguration());
                        EclEmmaCorePlugin.this.sessionManager.addSession(session, EclEmmaCorePlugin.this.preferences.getActivateNewSessions(), launch);
                    }
                    info.dispose();
                }
                ++i;
            }
        }

        private boolean checkCoverageDataFile(IPath path) {
            boolean ok = path.toFile().exists();
            if (!ok) {
                try {
                    EclEmmaCorePlugin.this.showPrompt(EclEmmaStatus.NO_COVERAGE_DATA_ERROR.getStatus(), path);
                }
                catch (CoreException e) {
                    EclEmmaCorePlugin.this.getLog().log(e.getStatus());
                }
            }
            return ok;
        }
    };
    private IElementChangedListener elementListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            EclEmmaCorePlugin eclEmmaCorePlugin = EclEmmaCorePlugin.this;
            synchronized (eclEmmaCorePlugin) {
                EclEmmaCorePlugin.this.allClassFiles = null;
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.sessionManager = new SessionManager();
        this.coverageLoader = new JavaCoverageLoader(this.sessionManager);
        this.stateFiles = new StateFiles(this.getStateLocation());
        this.stateFiles.deleteTemporaryFiles();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementListener);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.stateFiles.deleteTemporaryFiles();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementListener);
        DebugPlugin.getDefault().removeDebugEventListener(this.debugListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
        this.stateFiles = null;
        this.coverageLoader.dispose();
        this.coverageLoader = null;
        this.sessionManager = null;
        super.stop(context);
    }

    public static EclEmmaCorePlugin getInstance() {
        return instance;
    }

    public void setPreferences(ICorePreferences preferences) {
        this.preferences = preferences;
    }

    public DefaultInstrumentationFilter createDefaultIntrumentationFilter() {
        return new DefaultInstrumentationFilter(this.preferences);
    }

    public ISessionManager getSessionManager() {
        return this.sessionManager;
    }

    public JavaCoverageLoader getJavaCoverageLoader() {
        return this.coverageLoader;
    }

    public StateFiles getStateFiles() {
        return this.stateFiles;
    }

    public boolean showPrompt(IStatus status, Object info) throws CoreException {
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(PROMPT_STATUS);
        if (prompter == null) {
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
            return true;
        }
        return (Boolean)prompter.handleStatus(status, info);
    }

    public static IPath getAbsolutePath(IPath path) {
        IResource res;
        if (path.getDevice() == null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null) {
            return res.getLocation();
        }
        return path;
    }

    public static IClassFiles[] getClassFiles(IJavaProject project) throws JavaModelException {
        ClassFilesStore store = new ClassFilesStore();
        store.add(project);
        return store.getClassFiles();
    }

    public ClassFilesStore getAllClassFiles() throws CoreException {
        ClassFilesStore store = this.allClassFiles;
        if (store == null) {
            store = new ClassFilesStore();
            store.add(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
            this.allClassFiles = store;
        }
        return store;
    }
}

