/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.dialogs;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MergeSessionsDialog
extends ListSelectionDialog {
    private String description;
    private Text textdescr;

    public MergeSessionsDialog(Shell parent, ICoverageSession[] sessions, String description) {
        super(parent, (Object)sessions, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), UIMessages.MergeSessionsDialogSelection_label);
        this.setTitle(UIMessages.MergeSessionsDialog_title);
        this.setInitialSelections(sessions);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        ContextHelp.setHelp((Control)shell, "com.mountainminds.eclemma.ui.merge_sessions_context");
    }

    protected Label createMessageArea(Composite composite) {
        Label l = new Label(composite, 0);
        l.setFont(composite.getFont());
        l.setText(UIMessages.MergeSessionsDialogDescription_label);
        this.textdescr = new Text(composite, 2048);
        this.textdescr.setFont(composite.getFont());
        this.textdescr.setLayoutData((Object)new GridData(768));
        this.textdescr.setText(this.description);
        this.textdescr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        return super.createMessageArea(composite);
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        Button b1 = this.getButton(18);
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        Button b2 = this.getButton(19);
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeSessionsDialog.this.updateButtonsEnableState();
            }
        });
        return c;
    }

    protected void okPressed() {
        this.description = this.textdescr.getText().trim();
        super.okPressed();
    }

    protected void updateButtonsEnableState() {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(this.getViewer().getCheckedElements().length > 1 && this.textdescr.getText().trim().length() > 0);
        }
    }
}

