/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.ITypeVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeTraverser {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private final IPackageFragmentRoot[] roots;

    public TypeTraverser(IPackageFragmentRoot[] roots) {
        this.roots = roots;
    }

    public void process(ITypeVisitor visitor, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask("", this.roots.length);
        int i = 0;
        while (i < this.roots.length && !monitor.isCanceled()) {
            this.processPackageFragmentRoot(visitor, this.roots[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        visitor.done();
        monitor.done();
    }

    private void processPackageFragmentRoot(ITypeVisitor visitor, IPackageFragmentRoot root, IProgressMonitor monitor) throws JavaModelException {
        if (this.isOnClasspath(root)) {
            IJavaElement[] fragments = root.getChildren();
            monitor.beginTask("", fragments.length);
            int i = 0;
            while (i < fragments.length && !monitor.isCanceled()) {
                IPackageFragment fragment = (IPackageFragment)fragments[i];
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1);
                this.processPackageFragment(visitor, fragment, (IProgressMonitor)submonitor);
                ++i;
            }
        } else {
            TRACER.trace("Package fragment root {0} not on classpath.", root.getPath());
        }
        monitor.done();
    }

    private boolean isOnClasspath(IPackageFragmentRoot root) throws JavaModelException {
        IPath path = root.getPath();
        IJavaProject project = root.getJavaProject();
        return project.findPackageFragmentRoot(path) != null;
    }

    private void processPackageFragment(ITypeVisitor visitor, IPackageFragment fragment, IProgressMonitor monitor) throws JavaModelException {
        switch (fragment.getKind()) {
            case 1: {
                ICompilationUnit[] units = fragment.getCompilationUnits();
                monitor.beginTask("", units.length);
                int i = 0;
                while (i < units.length && !monitor.isCanceled()) {
                    this.processCompilationUnit(visitor, units[i], monitor);
                    monitor.worked(1);
                    ++i;
                }
                break;
            }
            case 2: {
                IClassFile[] classfiles = fragment.getClassFiles();
                monitor.beginTask("", classfiles.length);
                int i = 0;
                while (i < classfiles.length && !monitor.isCanceled()) {
                    this.processClassFile(visitor, classfiles[i], monitor);
                    monitor.worked(1);
                    ++i;
                }
                break;
            }
        }
        monitor.done();
    }

    private void processCompilationUnit(ITypeVisitor visitor, ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        IType[] types = unit.getTypes();
        int i = 0;
        while (i < types.length && !monitor.isCanceled()) {
            IType type = types[i];
            this.processType(visitor, new BinaryTypeName(type), type, monitor);
            ++i;
        }
    }

    private void processClassFile(ITypeVisitor visitor, IClassFile file, IProgressMonitor monitor) throws JavaModelException {
        IType type = file.getType();
        this.processType(visitor, new BinaryTypeName(type), type, monitor);
    }

    private void processType(ITypeVisitor visitor, BinaryTypeName btn, IType type, IProgressMonitor monitor) throws JavaModelException {
        String binaryname = btn.toString();
        monitor.subTask(binaryname);
        visitor.visit(type, binaryname);
        IJavaElement[] children = type.getChildren();
        int i = 0;
        while (i < children.length && !monitor.isCanceled()) {
            IJavaElement child = children[i];
            switch (child.getElementType()) {
                case 7: {
                    IType nestedtype = (IType)child;
                    this.processType(visitor, btn.nest(nestedtype), nestedtype, monitor);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.processAnonymousInnerTypes(visitor, btn, (IMember)child, monitor);
                }
            }
            ++i;
        }
    }

    private void processAnonymousInnerTypes(ITypeVisitor visitor, BinaryTypeName btn, IMember member, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] types = member.getChildren();
        int i = 0;
        while (i < types.length && !monitor.isCanceled()) {
            IType type = (IType)types[i];
            this.processType(visitor, btn.nest(type), type, monitor);
            ++i;
        }
    }

    private static class BinaryTypeName {
        private final String rootname;
        private final String typename;
        private final Ctr ctr;

        private BinaryTypeName(String rootname, String typename, Ctr ctr) {
            this.rootname = rootname;
            this.typename = typename;
            this.ctr = ctr;
        }

        public BinaryTypeName(IType roottype) {
            this.typename = this.rootname = roottype.getFullyQualifiedName().replace('.', '/');
            this.ctr = new Ctr();
        }

        public BinaryTypeName nest(IType type) throws JavaModelException {
            if (type.isAnonymous()) {
                return new BinaryTypeName(this.rootname, String.valueOf(this.rootname) + '$' + this.ctr.inc(), this.ctr);
            }
            return new BinaryTypeName(this.rootname, String.valueOf(this.typename) + '$' + type.getElementName(), this.ctr);
        }

        public String toString() {
            return this.typename;
        }

        private static class Ctr {
            private int i = 0;

            private Ctr() {
            }

            public int inc() {
                return ++this.i;
            }
        }
    }
}

