/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import edu.rice.cs.plt.tuple.Option;
import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StatementExpression;
import koala.dynamicjava.tree.TypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodCall
extends PrimaryExpression
implements StatementExpression {
    private Option<List<TypeName>> typeArgs;
    private String methodName;
    private List<Expression> arguments;

    protected MethodCall(Option<List<TypeName>> targs, String mn, List<? extends Expression> args, SourceInfo si) {
        super(si);
        if (mn == null || targs == null) {
            throw new IllegalArgumentException();
        }
        this.typeArgs = targs;
        this.methodName = mn;
        this.arguments = args == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(args);
    }

    public Option<List<TypeName>> getTypeArgs() {
        return this.typeArgs;
    }

    public void setTypeArgs(List<TypeName> targs) {
        this.typeArgs = Option.wrap(targs);
    }

    public void setTypeArgs(Option<List<TypeName>> targs) {
        if (targs == null) {
            throw new IllegalArgumentException();
        }
        this.typeArgs = targs;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.methodName = s;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<? extends Expression> l) {
        this.arguments = l == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(l);
    }
}

