/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.tuple;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.TotalOrder;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Tuple;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triple<T1, T2, T3>
extends Tuple {
    protected final T1 _first;
    protected final T2 _second;
    protected final T3 _third;

    public Triple(T1 first, T2 second, T3 third) {
        this._first = first;
        this._second = second;
        this._third = third;
    }

    public T1 first() {
        return this._first;
    }

    public T2 second() {
        return this._second;
    }

    public T3 third() {
        return this._third;
    }

    public String toString() {
        return "(" + this._first + ", " + this._second + ", " + this._third + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Triple cast = (Triple)o;
        return (this._first == null ? cast._first == null : this._first.equals(cast._first)) && (this._second == null ? cast._second == null : this._second.equals(cast._second)) && (this._third == null ? cast._third == null : this._third.equals(cast._third));
    }

    @Override
    protected int generateHashCode() {
        return (this._first == null ? 0 : this._first.hashCode()) ^ (this._second == null ? 0 : this._second.hashCode() << 1) ^ (this._third == null ? 0 : this._third.hashCode() << 2) ^ this.getClass().hashCode();
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> make(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    public static <T1, T2, T3> Lambda3<T1, T2, T3, Triple<T1, T2, T3>> factory() {
        return Factory.INSTANCE;
    }

    public static <T> Lambda<Triple<? extends T, ?, ?>, T> firstGetter() {
        return GetFirst.INSTANCE;
    }

    public static <T> Lambda<Triple<?, ? extends T, ?>, T> secondGetter() {
        return GetSecond.INSTANCE;
    }

    public static <T> Lambda<Triple<?, ?, ? extends T>, T> thirdGetter() {
        return GetThird.INSTANCE;
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>, T3 extends Comparable<? super T3>> TotalOrder<Triple<? extends T1, ? extends T2, ? extends T3>> comparator() {
        return new TripleComparator(CollectUtil.naturalOrder(), CollectUtil.naturalOrder(), CollectUtil.naturalOrder());
    }

    public static <T1, T2, T3> TotalOrder<Triple<? extends T1, ? extends T2, ? extends T3>> comparator(Comparator<? super T1> comp1, Comparator<? super T2> comp2, Comparator<? super T3> comp3) {
        return new TripleComparator<T1, T2, T3>(comp1, comp2, comp3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TripleComparator<T1, T2, T3>
    extends TotalOrder<Triple<? extends T1, ? extends T2, ? extends T3>> {
        private final Comparator<? super T1> _comp1;
        private final Comparator<? super T2> _comp2;
        private final Comparator<? super T3> _comp3;

        public TripleComparator(Comparator<? super T1> comp1, Comparator<? super T2> comp2, Comparator<? super T3> comp3) {
            this._comp1 = comp1;
            this._comp2 = comp2;
            this._comp3 = comp3;
        }

        @Override
        public int compare(Triple<? extends T1, ? extends T2, ? extends T3> t1, Triple<? extends T1, ? extends T2, ? extends T3> t2) {
            return ObjectUtil.compare(this._comp1, t1.first(), t2.first(), this._comp2, t1.second(), t2.second(), this._comp3, t1.third(), t2.third());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TripleComparator)) {
                return false;
            }
            TripleComparator cast = (TripleComparator)o;
            return ((Object)this._comp1).equals(cast._comp1) && ((Object)this._comp2).equals(cast._comp2) && ((Object)this._comp3).equals(cast._comp3);
        }

        public int hashCode() {
            return ObjectUtil.hash(TripleComparator.class, this._comp1, this._comp2, this._comp3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetThird<T>
    implements Lambda<Triple<?, ?, ? extends T>, T>,
    Serializable {
        public static final GetThird<Void> INSTANCE = new GetThird();

        private GetThird() {
        }

        @Override
        public T value(Triple<?, ?, ? extends T> arg) {
            return arg.third();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetSecond<T>
    implements Lambda<Triple<?, ? extends T, ?>, T>,
    Serializable {
        public static final GetSecond<Void> INSTANCE = new GetSecond();

        private GetSecond() {
        }

        @Override
        public T value(Triple<?, ? extends T, ?> arg) {
            return arg.second();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetFirst<T>
    implements Lambda<Triple<? extends T, ?, ?>, T>,
    Serializable {
        public static final GetFirst<Void> INSTANCE = new GetFirst();

        private GetFirst() {
        }

        @Override
        public T value(Triple<? extends T, ?, ?> arg) {
            return arg.first();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory<T1, T2, T3>
    implements Lambda3<T1, T2, T3, Triple<T1, T2, T3>>,
    Serializable {
        public static final Factory<Object, Object, Object> INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Triple<T1, T2, T3> value(T1 first, T2 second, T3 third) {
            return new Triple<T1, T2, T3>(first, second, third);
        }
    }
}

