/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.ExecutorIncrementalTaskController;
import edu.rice.cs.plt.concurrent.ExecutorTaskController;
import edu.rice.cs.plt.concurrent.FutureTaskController;
import edu.rice.cs.plt.concurrent.IncrementalTask;
import edu.rice.cs.plt.concurrent.IncrementalTaskController;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.concurrent.ProcessIncrementalTaskController;
import edu.rice.cs.plt.concurrent.ProcessTaskController;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.io.VoidOutputStream;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentUtil {
    public static final Runnable1<Long> SLEEPING_RUNNABLE = new SleepingRunnable();
    public static final Runnable1<Long> WORKING_RUNNABLE = new WorkingRunnable();
    public static final Executor THREAD_EXECUTOR = new Executor(){
        private int count = 0;

        public void execute(Runnable r) {
            new Thread(r, "THREAD_EXECUTOR-" + ++this.count).start();
        }
    };
    public static final Executor DIRECT_EXECUTOR = new Executor(){

        public void execute(Runnable r) {
            r.run();
        }
    };

    private ConcurrentUtil() {
    }

    public static void sleep(long delay) {
        SLEEPING_RUNNABLE.run(delay);
    }

    public static void work(long delay) {
        WORKING_RUNNABLE.run(delay);
    }

    public static long futureTimeNanos(long time, TimeUnit unit) {
        return System.nanoTime() + unit.toNanos(time);
    }

    public static long futureTimeMillis(long time, TimeUnit unit) {
        return System.currentTimeMillis() + unit.toMillis(time);
    }

    public static void waitUntilMillis(Object obj, long futureTime) throws InterruptedException, TimeoutException {
        long delta = futureTime - System.currentTimeMillis();
        if (delta <= 0L) {
            throw new TimeoutException();
        }
        obj.wait(delta);
    }

    public static void waitUntilNanos(Object obj, long futureTime) throws InterruptedException, TimeoutException {
        long delta = futureTime - System.nanoTime();
        if (delta <= 0L) {
            throw new TimeoutException();
        }
        TimeUnit.NANOSECONDS.timedWait(obj, delta);
    }

    public static <T> Callable<T> asCallable(Thunk<? extends T> thunk) {
        return new ThunkCallable<T>(thunk);
    }

    public static <T> TaskController<T> asTaskController(Future<? extends T> future) {
        FutureTaskController<T> result = new FutureTaskController<T>(LambdaUtil.valueLambda(future));
        result.start();
        return result;
    }

    public static <T> TaskController<T> asTaskController(Thunk<? extends Future<? extends T>> futureThunk) {
        return new FutureTaskController(futureThunk);
    }

    public static TaskController<Void> runInThread(Runnable task) {
        return ConcurrentUtil.computeWithExecutor(LambdaUtil.asThunk(task), THREAD_EXECUTOR, true);
    }

    public static TaskController<Void> runInThread(Runnable task, boolean start) {
        return ConcurrentUtil.computeWithExecutor(LambdaUtil.asThunk(task), THREAD_EXECUTOR, start);
    }

    public static <R> TaskController<R> computeInThread(Thunk<? extends R> task) {
        return ConcurrentUtil.computeWithExecutor(task, THREAD_EXECUTOR, true);
    }

    public static <R> TaskController<R> computeInThread(Thunk<? extends R> task, boolean start) {
        return ConcurrentUtil.computeWithExecutor(task, THREAD_EXECUTOR, start);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(IncrementalTask<? extends I, ? extends R> task) {
        return ConcurrentUtil.computeWithExecutor(task, THREAD_EXECUTOR, true, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(IncrementalTask<? extends I, ? extends R> task, boolean start) {
        return ConcurrentUtil.computeWithExecutor(task, THREAD_EXECUTOR, start, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInThread(IncrementalTask<? extends I, ? extends R> task, boolean start, boolean ignoreIntermediate) {
        return ConcurrentUtil.computeWithExecutor(task, THREAD_EXECUTOR, start, ignoreIntermediate);
    }

    public static <R> TaskController<R> computeWithExecutor(Thunk<? extends R> task, Executor exec) {
        return ConcurrentUtil.computeWithExecutor(task, exec, true);
    }

    public static <R> TaskController<R> computeWithExecutor(Thunk<? extends R> task, Executor exec, boolean start) {
        ExecutorTaskController<R> result = new ExecutorTaskController<R>(exec, task);
        if (start) {
            result.start();
        }
        return result;
    }

    public static <I, R> IncrementalTaskController<I, R> computeWithExecutor(IncrementalTask<? extends I, ? extends R> task, Executor exec) {
        return ConcurrentUtil.computeWithExecutor(task, exec, true, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeWithExecutor(IncrementalTask<? extends I, ? extends R> task, Executor exec, boolean start) {
        return ConcurrentUtil.computeWithExecutor(task, exec, start, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeWithExecutor(IncrementalTask<? extends I, ? extends R> task, Executor exec, boolean start, boolean ignoreIntermediate) {
        ExecutorIncrementalTaskController<I, R> result = new ExecutorIncrementalTaskController<I, R>(exec, task, ignoreIntermediate);
        if (start) {
            result.start();
        }
        return result;
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task) {
        return ConcurrentUtil.computeInProcess(task, JVMBuilder.DEFAULT, true);
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task, boolean start) {
        return ConcurrentUtil.computeInProcess(task, JVMBuilder.DEFAULT, start);
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task, JVMBuilder jvmBuilder) {
        return ConcurrentUtil.computeInProcess(task, jvmBuilder, true);
    }

    public static <R> TaskController<R> computeInProcess(Thunk<? extends R> task, JVMBuilder jvmBuilder, boolean start) {
        jvmBuilder = jvmBuilder.addDefaultProperties(ConcurrentUtil.getProperties("plt."));
        ProcessTaskController<R> controller = new ProcessTaskController<R>(jvmBuilder, THREAD_EXECUTOR, task);
        if (start) {
            controller.start();
        }
        return controller;
    }

    public static <I, R> IncrementalTaskController<I, R> computeInProcess(IncrementalTask<? extends I, ? extends R> task) {
        return ConcurrentUtil.computeInProcess(task, JVMBuilder.DEFAULT, true, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInProcess(IncrementalTask<? extends I, ? extends R> task, boolean start) {
        return ConcurrentUtil.computeInProcess(task, JVMBuilder.DEFAULT, start, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInProcess(IncrementalTask<? extends I, ? extends R> task, JVMBuilder jvmBuilder) {
        return ConcurrentUtil.computeInProcess(task, jvmBuilder, true, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInProcess(IncrementalTask<? extends I, ? extends R> task, JVMBuilder jvmBuilder, boolean start) {
        return ConcurrentUtil.computeInProcess(task, jvmBuilder, start, false);
    }

    public static <I, R> IncrementalTaskController<I, R> computeInProcess(IncrementalTask<? extends I, ? extends R> task, JVMBuilder jvmBuilder, boolean start, boolean ignoreIntermediate) {
        jvmBuilder = jvmBuilder.addDefaultProperties(ConcurrentUtil.getProperties("plt."));
        ProcessIncrementalTaskController<I, R> controller = new ProcessIncrementalTaskController<I, R>(jvmBuilder, THREAD_EXECUTOR, task, ignoreIntermediate);
        if (start) {
            controller.start();
        }
        return controller;
    }

    public static Remote exportInProcess(Thunk<? extends Remote> factory) throws InterruptedException, ExecutionException, IOException {
        return ConcurrentUtil.exportInProcess(factory, JVMBuilder.DEFAULT, null);
    }

    public static Remote exportInProcess(Thunk<? extends Remote> factory, JVMBuilder jvmBuilder) throws InterruptedException, ExecutionException, IOException {
        return ConcurrentUtil.exportInProcess(factory, jvmBuilder, null);
    }

    public static Remote exportInProcess(Thunk<? extends Remote> factory, JVMBuilder jvmBuilder, Runnable1<? super Process> onExit) throws InterruptedException, ExecutionException, IOException {
        ExportRemoteTask task = new ExportRemoteTask(factory);
        Executor exec = onExit == null ? DIRECT_EXECUTOR : THREAD_EXECUTOR;
        jvmBuilder = jvmBuilder.addDefaultProperty("java.rmi.server.hostname", "127.0.0.1");
        jvmBuilder = jvmBuilder.addDefaultProperties(ConcurrentUtil.getProperties("plt."));
        try {
            return (Remote)new ProcessTaskController<Remote>(jvmBuilder, exec, task, onExit).get();
        }
        catch (CancellationException e) {
            throw new InterruptedException();
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static boolean processIsTerminated(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static void onProcessExit(final Process p, final Runnable1<? super Process> listener) {
        Thread t = new Thread("ConcurrentUtil.onProcessExit"){

            public void run() {
                try {
                    p.waitFor();
                    listener.run(p);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void discardProcessOutput(Process p) {
        ConcurrentUtil.copyProcessOut(p, VoidOutputStream.INSTANCE);
        ConcurrentUtil.copyProcessErr(p, VoidOutputStream.INSTANCE);
    }

    public static void copyProcessOutput(Process p, OutputStream out, OutputStream err) {
        ConcurrentUtil.copyProcessOut(p, out);
        ConcurrentUtil.copyProcessErr(p, err);
    }

    public static Thread discardProcessOut(Process p) {
        return ConcurrentUtil.copyProcessOut(p, VoidOutputStream.INSTANCE);
    }

    public static Thread copyProcessOut(Process p, OutputStream out) {
        return ConcurrentUtil.copyProcessOut(p, out, true);
    }

    public static Thread copyProcessOut(Process p, OutputStream out, boolean close) {
        Thread result = new Thread((Runnable)new CopyStream(p.getInputStream(), out, close), "ConcurrentUtil.copyProcessOut");
        result.setDaemon(true);
        result.start();
        return result;
    }

    public static TaskController<String> processOutAsString(Process p) {
        return ConcurrentUtil.computeInThread(new StreamToString(p.getInputStream()));
    }

    public static TaskController<String> processOutAsString(Process p, Executor exec) {
        return ConcurrentUtil.computeWithExecutor(new StreamToString(p.getInputStream()), exec);
    }

    public static Thread discardProcessErr(Process p) {
        return ConcurrentUtil.copyProcessErr(p, VoidOutputStream.INSTANCE);
    }

    public static Thread copyProcessErr(Process p, OutputStream err) {
        return ConcurrentUtil.copyProcessErr(p, err, false);
    }

    public static Thread copyProcessErr(Process p, OutputStream err, boolean close) {
        Thread result = new Thread((Runnable)new CopyStream(p.getErrorStream(), err, close), "ConcurrentUtil.copyProcessErr");
        result.setDaemon(true);
        result.start();
        return result;
    }

    public static TaskController<String> processErrAsString(Process p) {
        return ConcurrentUtil.computeInThread(new StreamToString(p.getErrorStream()));
    }

    public static TaskController<String> processErrAsString(Process p, Executor exec) {
        return ConcurrentUtil.computeWithExecutor(new StreamToString(p.getErrorStream()), exec);
    }

    public static Properties getProperties(String ... prefixes) {
        Properties result = new Properties();
        block0: for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            for (String prefix : prefixes) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(prefix)) continue;
                result.put(entry.getKey(), entry.getValue());
                continue block0;
            }
        }
        return result;
    }

    public static Map<String, String> getPropertiesAsMap(String ... prefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            for (String prefix : prefixes) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(prefix)) continue;
                result.put((String)entry.getKey(), entry.getValue().toString());
                continue block0;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StreamToString
    implements Thunk<String> {
        private final InputStream _stream;

        public StreamToString(InputStream stream) {
            this._stream = stream;
        }

        @Override
        public String value() {
            try {
                return IOUtil.toString(new InputStreamReader(this._stream));
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
    }

    private static final class CopyStream
    implements Runnable,
    Serializable {
        private final InputStream _in;
        private final OutputStream _out;
        private final boolean _close;

        public CopyStream(InputStream in, OutputStream out, boolean close) {
            this._in = in;
            this._out = out;
            this._close = close;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    IOUtil.copyInputStream(this._in, this._out);
                }
                finally {
                    if (this._close) {
                        this._out.close();
                    }
                }
            }
            catch (IOException e) {
                DebugUtil.error.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportRemoteTask
    implements Thunk<Remote>,
    Serializable {
        private final Thunk<? extends Remote> _factory;
        private static final List<Remote> _cache = new ArrayList<Remote>(1);

        public ExportRemoteTask(Thunk<? extends Remote> factory) {
            this._factory = factory;
        }

        @Override
        public Remote value() {
            Remote server = this._factory.value();
            _cache.add(server);
            try {
                return UnicastRemoteObject.exportObject(server, 0);
            }
            catch (RemoteException e) {
                throw new WrappedException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ThunkCallable<T>
    implements Callable<T>,
    Serializable {
        private final Thunk<? extends T> _thunk;

        public ThunkCallable(Thunk<? extends T> thunk) {
            this._thunk = thunk;
        }

        @Override
        public T call() {
            return this._thunk.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WorkingRunnable
    implements Runnable1<Long>,
    Serializable {
        private long junk = 1L;

        private WorkingRunnable() {
        }

        @Override
        public void run(Long delay) {
            long finished = System.currentTimeMillis() + delay;
            while (System.currentTimeMillis() < finished && !Thread.interrupted()) {
                for (int i = 0; i < 10000; ++i) {
                    this.junk *= delay + 1L;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SleepingRunnable
    implements Runnable1<Long>,
    Serializable {
        private SleepingRunnable() {
        }

        @Override
        public void run(Long delay) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

