/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import java.util.Arrays;

public class VariableData {
    private String _name;
    private ModifiersAndVisibility _modifiersAndVisibility;
    private InstanceData _type;
    private boolean _hasBeenAssigned;
    private boolean _hasInitializer;
    private Data _enclosingData;
    private boolean _generated;
    private boolean _isLocalVariable;

    public VariableData(String name, ModifiersAndVisibility modifiersAndVisibility, SymbolData type, boolean hasBeenAssigned, Data enclosingData) {
        this._name = name;
        this._modifiersAndVisibility = modifiersAndVisibility;
        this._type = type.getInstanceData();
        this._hasBeenAssigned = hasBeenAssigned;
        this._enclosingData = enclosingData;
        this._hasInitializer = false;
        this._generated = false;
        this._isLocalVariable = false;
    }

    public VariableData(SymbolData type) {
        this._name = "";
        this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[0]);
        this._type = type.getInstanceData();
        this._hasBeenAssigned = false;
        this._isLocalVariable = true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VariableData vd = (VariableData)obj;
        if (!this._name.equals(vd.getName())) {
            return false;
        }
        if (!this._modifiersAndVisibility.equals(vd.getMav())) {
            return false;
        }
        if (!this._type.equals(vd.getType())) {
            return false;
        }
        if (this._hasBeenAssigned != vd.hasValue()) {
            return false;
        }
        if (this._hasInitializer != vd._hasInitializer) {
            return false;
        }
        Data otherEnclosingData = vd.getEnclosingData();
        if (this._enclosingData == null) {
            return otherEnclosingData == null;
        }
        return this._enclosingData == otherEnclosingData;
    }

    public int hashCode() {
        return this.getEnclosingData().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return "VariableData(" + this._name + ", " + Arrays.toString(this._modifiersAndVisibility.getModifiers()) + ", " + this._type + ", " + this._hasBeenAssigned + ")";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    public ModifiersAndVisibility getMav() {
        return this._modifiersAndVisibility;
    }

    public void setMav(ModifiersAndVisibility mav) {
        this._modifiersAndVisibility = mav;
    }

    public InstanceData getType() {
        return this._type;
    }

    public Data getEnclosingData() {
        return this._enclosingData;
    }

    public void setEnclosingData(Data d) {
        this._enclosingData = d;
    }

    public boolean isLocalVariable() {
        return this._isLocalVariable;
    }

    public void setIsLocalVariable(boolean b) {
        this._isLocalVariable = b;
    }

    public void setFinal() {
        if (!this.isFinal()) {
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = "final";
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NO_INFO, newModifiers);
        }
    }

    public void setPrivate() {
        if (!this.hasModifier("private")) {
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = "private";
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NO_INFO, newModifiers);
        }
    }

    public void addModifier(String s) {
        if (!this.hasModifier(s)) {
            String[] modifiers = this._modifiersAndVisibility.getModifiers();
            String[] newModifiers = new String[modifiers.length + 1];
            newModifiers[0] = s;
            for (int i = 1; i <= modifiers.length; ++i) {
                newModifiers[i] = modifiers[i - 1];
            }
            this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NO_INFO, newModifiers);
        }
    }

    public void setPrivateAndFinal() {
        this.setPrivate();
        this.setFinal();
    }

    public void setFinalAndStatic() {
        this.setFinal();
        this.addModifier("static");
    }

    public boolean isFinal() {
        return this.hasModifier("final");
    }

    public boolean isPrivate() {
        return this.hasModifier("private");
    }

    public boolean isStatic() {
        return this.hasModifier("static");
    }

    public boolean hasModifier(String modifier) {
        String[] mavStrings = this._modifiersAndVisibility.getModifiers();
        for (int i = 0; i < mavStrings.length; ++i) {
            if (!mavStrings[i].equals(modifier)) continue;
            return true;
        }
        return false;
    }

    public void setGenerated(boolean value) {
        this._generated = value;
    }

    public boolean isGenerated() {
        return this._generated;
    }

    public boolean hasInitializer() {
        return this._hasInitializer;
    }

    public void setHasInitializer(boolean value) {
        this._hasInitializer = value;
    }

    public boolean hasValue() {
        return this._hasBeenAssigned;
    }

    public boolean gotValue() {
        if (this.hasValue()) {
            return false;
        }
        this._hasBeenAssigned = true;
        return true;
    }

    public boolean lostValue() {
        if (this.hasValue()) {
            this._hasBeenAssigned = false;
            return true;
        }
        return false;
    }
}

