/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.FullJavaVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.SuperReference;
import edu.rice.cs.javalanglevels.tree.ThisReference;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyFullJavaVisitor
extends FullJavaVisitor {
    private SymbolData _symbolData;

    public InterfaceBodyFullJavaVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._symbolData = sd;
    }

    @Override
    public Void forStatementDoFirst(Statement that) {
        return null;
    }

    @Override
    public Void forConcreteMethodDefDoFirst(ConcreteMethodDef that) {
        InterfaceBodyFullJavaVisitor._addError("You cannot have concrete methods definitions in interfaces", that);
        return null;
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        InterfaceBodyFullJavaVisitor._addError("This open brace must mark the beginning of an interface body", that);
        return null;
    }

    @Override
    public Void forVariableDeclarationOnly(VariableDeclaration that) {
        return null;
    }

    @Override
    public Void forThisReferenceDoFirst(ThisReference that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("The field 'this' does not exist in interfaces.  Only classes have a 'this' field.", that);
        return null;
    }

    @Override
    public Void forSuperReferenceDoFirst(SuperReference that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("The field 'super' does not exist in interfaces.  Only classes have a 'super' field", that);
        return null;
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef that) {
        this.forAbstractMethodDefDoFirst(that);
        if (InterfaceBodyFullJavaVisitor._checkError()) {
            return null;
        }
        MethodData md = this.createMethodData(that, this._symbolData);
        if (md.hasModifier("private")) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Interface methods cannot be made private.  They must be public.", that.getMav());
        }
        if (md.hasModifier("protected")) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Interface methods cannot be made protected.  They must be public.", that.getMav());
        }
        md.addModifier("public");
        md.addModifier("abstract");
        String className = InterfaceBodyFullJavaVisitor.getUnqualifiedClassName(this._symbolData.getName());
        if (className.equals(md.getName())) {
            InterfaceBodyFullJavaVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors cannot appear in interfaces.", that);
        } else {
            this._symbolData.addMethod(md);
        }
        return null;
    }

    @Override
    public Void forInnerInterfaceDef(InnerInterfaceDef that) {
        this.handleInnerInterfaceDef(that, this._symbolData, this.getQualifiedClassName(this._symbolData.getName()) + "." + that.getName().getText());
        return null;
    }

    @Override
    public Void forInnerClassDef(InnerClassDef that) {
        this.handleInnerClassDef(that, this._symbolData, this.getQualifiedClassName(this._symbolData.getName()) + "." + that.getName().getText());
        return null;
    }

    @Override
    public Void forConstructorDefDoFirst(ConstructorDef that) {
        InterfaceBodyFullJavaVisitor._addAndIgnoreError("Constructor definitions cannot appear in interfaces", that);
        return null;
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._symbolData);
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._symbolData);
        return null;
    }

    static /* synthetic */ SymbolData access$000(InterfaceBodyFullJavaVisitor x0) {
        return x0._symbolData;
    }

    static /* synthetic */ SymbolData access$002(InterfaceBodyFullJavaVisitor x0, SymbolData x1) {
        x0._symbolData = x1;
        return x0._symbolData;
    }
}

