/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.model.DummyDocumentRegion;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParserFacade;
import edu.rice.cs.drjava.project.ProjectProfile;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.sexp.BoolAtom;
import edu.rice.cs.util.sexp.Cons;
import edu.rice.cs.util.sexp.Empty;
import edu.rice.cs.util.sexp.NumberAtom;
import edu.rice.cs.util.sexp.SEList;
import edu.rice.cs.util.sexp.SEListVisitor;
import edu.rice.cs.util.sexp.SExp;
import edu.rice.cs.util.sexp.SExpParseException;
import edu.rice.cs.util.sexp.SExpParser;
import edu.rice.cs.util.sexp.SExpVisitor;
import edu.rice.cs.util.sexp.TextAtom;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileParser
extends ProjectFileParserFacade {
    public static final ProjectFileParser ONLY = new ProjectFileParser();
    private String _parent;
    private String _srcFileBase;
    BreakpointListVisitor breakpointListVisitor = new BreakpointListVisitor();
    BookmarkListVisitor bookmarkListVisitor = new BookmarkListVisitor();

    private ProjectFileParser() {
        this._xmlProjectFile = false;
    }

    @Override
    public ProjectFileIR parse(File projFile) throws IOException, FileNotFoundException, MalformedProjectFileException {
        this._projectFile = projFile;
        this._srcFileBase = this._parent = projFile.getParent();
        List<SEList> forest = null;
        try {
            forest = SExpParser.parse(projFile);
        }
        catch (SExpParseException e) {
            throw new MalformedProjectFileException("Parse Error: " + e.getMessage());
        }
        ProjectProfile pfir = new ProjectProfile(projFile);
        pfir.setDrJavaVersion("unknown");
        try {
            for (SEList exp : forest) {
                this.evaluateExpression(exp, pfir, new DocFileListVisitor(this._parent));
            }
        }
        catch (PrivateProjectException e) {
            throw new MalformedProjectFileException("Parse Error: " + e.getMessage());
        }
        return pfir;
    }

    private void evaluateExpression(SEList e, ProjectFileIR pfir, DocFileListVisitor flv) throws IOException {
        if (e == Empty.ONLY) {
            return;
        }
        Cons exp = (Cons)e;
        String name = exp.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("source") == 0 || name.compareToIgnoreCase("source-files") == 0) {
            List<DocFile> dfList = exp.getRest().accept(new DocFileListVisitor(this._srcFileBase));
            pfir.setSourceFiles(dfList);
        } else if (name.compareToIgnoreCase("proj-root") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple source roots");
            }
            if (fList.size() == 0) {
                throw new PrivateProjectException("Cannot have no source roots");
            }
            pfir.setProjectRoot(fList.get(0));
        } else if (name.compareToIgnoreCase("proj-root-and-base") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple source roots");
            }
            if (fList.size() == 0) {
                throw new PrivateProjectException("Cannot have no source roots");
            }
            File root = fList.get(0);
            if (!root.exists()) {
                throw new IOException("Project root " + root + " no longer exists");
            }
            pfir.setProjectRoot(root);
            this._srcFileBase = root.getCanonicalPath();
        } else if (name.compareToIgnoreCase("proj-manifest") == 0) {
            List<String> sList = exp.getRest().accept(PathListVisitor.ONLY);
            if (sList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple manifests");
            }
            if (sList.size() > 0) {
                pfir.setCustomManifest(sList.get(0));
            }
        } else if (name.compareToIgnoreCase("auxiliary") == 0) {
            List<DocFile> dfList = exp.getRest().accept(flv);
            pfir.setAuxiliaryFiles(dfList);
        } else if (name.compareToIgnoreCase("collapsed") == 0) {
            List<String> sList = exp.getRest().accept(PathListVisitor.ONLY);
            pfir.setCollapsedPaths(sList);
        } else if (name.compareToIgnoreCase("build-dir") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple build directories");
            }
            if (fList.size() == 0) {
                pfir.setBuildDirectory(FileOps.NULL_FILE);
            } else {
                pfir.setBuildDirectory(fList.get(0));
            }
        } else if (name.compareToIgnoreCase("work-dir") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have multiple working directories");
            }
            pfir.setWorkingDirectory(fList.get(0));
        } else if (name.compareToIgnoreCase("classpaths") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            pfir.setClassPaths(fList);
        } else if (name.compareToIgnoreCase("main-class") == 0) {
            try {
                List<DocFile> fList = exp.getRest().accept(flv);
                if (fList.size() == 1) {
                    String main = fList.get(0).getAbsolutePath();
                    pfir.setMainClass(main);
                    return;
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            String mainClass = exp.getRest().accept(NameVisitor.ONLY);
            pfir.setMainClass(mainClass);
        } else if (name.compareToIgnoreCase("create-jar-file") == 0) {
            List<DocFile> fList = exp.getRest().accept(flv);
            if (fList.size() > 1) {
                throw new PrivateProjectException("Cannot have more than one \"create jar\" file");
            }
            if (fList.size() == 0) {
                pfir.setCreateJarFile(null);
            } else {
                pfir.setCreateJarFile(fList.get(0));
            }
        } else if (name.compareToIgnoreCase("create-jar-flags") == 0) {
            Integer i = exp.getRest().accept(NumberVisitor.ONLY);
            pfir.setCreateJarFlags(i);
        } else if (name.compareToIgnoreCase("breakpoints") == 0) {
            List<DebugBreakpointData> bpList = exp.getRest().accept(this.breakpointListVisitor);
            pfir.setBreakpoints(bpList);
        } else if (name.compareToIgnoreCase("watches") == 0) {
            List<DebugWatchData> sList = exp.getRest().accept(WatchListVisitor.ONLY);
            pfir.setWatches(sList);
        } else if (name.compareToIgnoreCase("bookmarks") == 0) {
            List<FileRegion> bmList = exp.getRest().accept(this.bookmarkListVisitor);
            pfir.setBookmarks(bmList);
        }
    }

    DocFile parseFile(SExp s, String pathRoot) {
        String name = s.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("file") != 0) {
            throw new PrivateProjectException("Expected a file tag, found: " + name);
        }
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException("Expected a labeled node, found a label: " + name);
        }
        SEList c = ((Cons)s).getRest();
        DocFilePropertyVisitor v = new DocFilePropertyVisitor(pathRoot);
        return c.accept(v);
    }

    private String parseFileName(SExp s) {
        if (s instanceof Cons) {
            SEList l = ((Cons)s).getRest();
            if (l == Empty.ONLY) {
                throw new PrivateProjectException("expected filename, but nothing found");
            }
            String name = l.accept(NameVisitor.ONLY);
            name = StringOps.replace(name, "\\", "/");
            return name;
        }
        throw new PrivateProjectException("expected name tag, found string");
    }

    private int parseInt(SExp s) {
        if (s instanceof Cons) {
            SEList l = ((Cons)s).getRest();
            if (l == Empty.ONLY) {
                throw new PrivateProjectException("expected integer, but nothing found");
            }
            int i = l.accept(NumberVisitor.ONLY);
            return i;
        }
        throw new PrivateProjectException("expected name tag, found string");
    }

    private Pair<Integer, Integer> parseIntPair(SExp s) {
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException("expected name tag, found string");
        }
        final ArrayList intList = new ArrayList();
        SEList l = ((Cons)s).getRest();
        List<Integer> li = l.accept(new SExpVisitor<List<Integer>>(){

            @Override
            public List<Integer> forEmpty(Empty e) {
                return intList;
            }

            @Override
            public List<Integer> forCons(Cons c) {
                c.getFirst().accept(this);
                return c.getRest().accept(this);
            }

            @Override
            public List<Integer> forBoolAtom(BoolAtom b) {
                throw new PrivateProjectException("unexpected boolean found, int expected");
            }

            @Override
            public List<Integer> forNumberAtom(NumberAtom n) {
                intList.add(n.intValue());
                return intList;
            }

            @Override
            public List<Integer> forTextAtom(TextAtom t) {
                throw new PrivateProjectException("unexpected string found where number expected: " + t.getText());
            }
        });
        if (li.size() == 2) {
            return new Pair<Integer, Integer>(li.get(0), li.get(1));
        }
        throw new PrivateProjectException("expected a list of 2 ints for select, found list of size " + li.size());
    }

    private String parseStringNode(SExp n) {
        if (n instanceof Cons) {
            return ((Cons)n).getRest().accept(NameVisitor.ONLY);
        }
        throw new PrivateProjectException("List expected, but found text instead");
    }

    DebugBreakpointData parseBreakpoint(SExp s, String pathRoot) {
        String name = s.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("breakpoint") != 0) {
            throw new PrivateProjectException("Expected a breakpoint tag, found: " + name);
        }
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException("Expected a labeled node, found a label: " + name);
        }
        SEList c = ((Cons)s).getRest();
        BreakpointPropertyVisitor v = new BreakpointPropertyVisitor(pathRoot);
        return c.accept(v);
    }

    FileRegion parseBookmark(SExp s, String pathRoot) {
        String name = s.accept(NameVisitor.ONLY);
        if (name.compareToIgnoreCase("bookmark") != 0) {
            throw new PrivateProjectException("Expected a bookmark tag, found: " + name);
        }
        if (!(s instanceof Cons)) {
            throw new PrivateProjectException("Expected a labeled node, found a label: " + name);
        }
        SEList c = ((Cons)s).getRest();
        BookmarkPropertyVisitor v = new BookmarkPropertyVisitor(pathRoot);
        return c.accept(v);
    }

    private static class PrivateProjectException
    extends RuntimeException {
        public PrivateProjectException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BookmarkPropertyVisitor
    implements SEListVisitor<FileRegion> {
        private String fname = null;
        private Integer startOffset = null;
        private Integer endOffset = null;
        private String pathRoot;

        public BookmarkPropertyVisitor(String pr) {
            this.pathRoot = pr;
        }

        @Override
        public FileRegion forCons(Cons c) {
            String name = c.getFirst().accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("name") == 0) {
                this.fname = ONLY.parseFileName(c.getFirst());
            } else if (name.compareToIgnoreCase("start") == 0) {
                this.startOffset = ONLY.parseInt(c.getFirst());
            } else if (name.compareToIgnoreCase("end") == 0) {
                this.endOffset = ONLY.parseInt(c.getFirst());
            }
            return c.getRest().accept(this);
        }

        @Override
        public FileRegion forEmpty(Empty c) {
            if (this.fname == null || this.startOffset == null || this.endOffset == null) {
                throw new PrivateProjectException("Bookmark information incomplete, need name, start offset and end offset");
            }
            File f = this.pathRoot == null || new File(this.fname).isAbsolute() ? new File(this.fname) : new File(this.pathRoot, this.fname);
            return new DummyDocumentRegion(f, this.startOffset, this.endOffset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BookmarkListVisitor
    implements SEListVisitor<List<FileRegion>> {
        private BookmarkListVisitor() {
        }

        @Override
        public List<FileRegion> forEmpty(Empty e) {
            return new ArrayList<FileRegion>();
        }

        @Override
        public List<FileRegion> forCons(Cons c) {
            List<FileRegion> list = c.getRest().accept(this);
            FileRegion tmp = ONLY.parseBookmark(c.getFirst(), ProjectFileParser.this._srcFileBase);
            list.add(0, tmp);
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BreakpointPropertyVisitor
    implements SEListVisitor<DebugBreakpointData> {
        private String fname = null;
        private Integer lineNumber = null;
        private boolean isEnabled = false;
        private String pathRoot;

        public BreakpointPropertyVisitor(String pr) {
            this.pathRoot = pr;
        }

        @Override
        public DebugBreakpointData forCons(Cons c) {
            String name = c.getFirst().accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("name") == 0) {
                this.fname = ONLY.parseFileName(c.getFirst());
            } else if (name.compareToIgnoreCase("line") == 0) {
                this.lineNumber = ONLY.parseInt(c.getFirst());
            } else if (name.compareToIgnoreCase("enabled") == 0) {
                this.isEnabled = true;
            }
            return c.getRest().accept(this);
        }

        @Override
        public DebugBreakpointData forEmpty(Empty c) {
            if (this.fname == null || this.lineNumber == null) {
                throw new PrivateProjectException("Breakpoint information incomplete, need name and line tags");
            }
            if (this.pathRoot == null || new File(this.fname).isAbsolute()) {
                final File f = new File(this.fname);
                return new DebugBreakpointData(){

                    public File getFile() {
                        return f;
                    }

                    public int getLineNumber() {
                        return BreakpointPropertyVisitor.this.lineNumber;
                    }

                    public boolean isEnabled() {
                        return BreakpointPropertyVisitor.this.isEnabled;
                    }
                };
            }
            final File f = new File(this.pathRoot, this.fname);
            return new DebugBreakpointData(){

                public File getFile() {
                    return f;
                }

                public int getLineNumber() {
                    return BreakpointPropertyVisitor.this.lineNumber;
                }

                public boolean isEnabled() {
                    return BreakpointPropertyVisitor.this.isEnabled;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreakpointListVisitor
    implements SEListVisitor<List<DebugBreakpointData>> {
        private BreakpointListVisitor() {
        }

        @Override
        public List<DebugBreakpointData> forEmpty(Empty e) {
            return new ArrayList<DebugBreakpointData>();
        }

        @Override
        public List<DebugBreakpointData> forCons(Cons c) {
            List<DebugBreakpointData> list = c.getRest().accept(this);
            DebugBreakpointData tmp = ONLY.parseBreakpoint(c.getFirst(), ProjectFileParser.this._srcFileBase);
            list.add(0, tmp);
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatchListVisitor
    implements SEListVisitor<List<DebugWatchData>> {
        public static final WatchListVisitor ONLY = new WatchListVisitor();

        private WatchListVisitor() {
        }

        @Override
        public List<DebugWatchData> forEmpty(Empty e) {
            return new ArrayList<DebugWatchData>();
        }

        @Override
        public List<DebugWatchData> forCons(Cons c) {
            List<DebugWatchData> list = c.getRest().accept(this);
            SExp first = c.getFirst();
            String name = first.accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("watch") == 0) {
                String tmp = ONLY.parseStringNode(c.getFirst());
                list.add(0, new DebugWatchData(tmp));
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberVisitor
    implements SExpVisitor<Integer> {
        public static final NumberVisitor ONLY = new NumberVisitor();

        private NumberVisitor() {
        }

        @Override
        public Integer forEmpty(Empty e) {
            throw new PrivateProjectException("Found an empty node, expected an integer");
        }

        @Override
        public Integer forCons(Cons c) {
            return c.getFirst().accept(this);
        }

        @Override
        public Integer forBoolAtom(BoolAtom b) {
            throw new PrivateProjectException("Found a boolean, expected an integer");
        }

        @Override
        public Integer forNumberAtom(NumberAtom n) {
            return n.intValue();
        }

        @Override
        public Integer forTextAtom(TextAtom t) {
            throw new PrivateProjectException("Found a string '" + t + "', expected an integer");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameVisitor
    implements SExpVisitor<String> {
        public static final NameVisitor ONLY = new NameVisitor();

        private NameVisitor() {
        }

        @Override
        public String forEmpty(Empty e) {
            throw new PrivateProjectException("Found an empty node, expected a labeled node");
        }

        @Override
        public String forCons(Cons c) {
            return c.getFirst().accept(this);
        }

        @Override
        public String forBoolAtom(BoolAtom b) {
            throw new PrivateProjectException("Found a boolean, expected a label");
        }

        @Override
        public String forNumberAtom(NumberAtom n) {
            throw new PrivateProjectException("Found a number, expected a label");
        }

        @Override
        public String forTextAtom(TextAtom t) {
            return t.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathListVisitor
    implements SEListVisitor<List<String>> {
        public static final PathListVisitor ONLY = new PathListVisitor();

        private PathListVisitor() {
        }

        @Override
        public List<String> forEmpty(Empty e) {
            return new ArrayList<String>();
        }

        @Override
        public List<String> forCons(Cons c) {
            List<String> list = c.getRest().accept(this);
            SExp first = c.getFirst();
            String name = first.accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("path") == 0) {
                String tmp = ONLY.parseStringNode(c.getFirst());
                list.add(0, tmp);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocFilePropertyVisitor
    implements SEListVisitor<DocFile> {
        private String fname = "";
        private Pair<Integer, Integer> select = new Pair<Integer, Integer>(0, 0);
        private Pair<Integer, Integer> scroll = new Pair<Integer, Integer>(0, 0);
        private boolean active = false;
        private String pack = "";
        private Date modDate = null;
        private String pathRoot;

        public DocFilePropertyVisitor(String pr) {
            this.pathRoot = pr;
        }

        @Override
        public DocFile forCons(Cons c) {
            String name = c.getFirst().accept(NameVisitor.ONLY);
            if (name.compareToIgnoreCase("name") == 0) {
                this.fname = ONLY.parseFileName(c.getFirst());
            } else if (name.compareToIgnoreCase("select") == 0) {
                this.select = ONLY.parseIntPair(c.getFirst());
            } else if (name.compareToIgnoreCase("scroll") == 0) {
                this.scroll = ONLY.parseIntPair(c.getFirst());
            } else if (name.compareToIgnoreCase("active") == 0) {
                this.active = true;
            } else if (name.compareToIgnoreCase("package") == 0) {
                this.pack = ONLY.parseStringNode(c.getFirst());
            } else if (name.compareToIgnoreCase("mod-date") == 0) {
                String tmp = ONLY.parseStringNode(c.getFirst());
                try {
                    this.modDate = ProjectProfile.MOD_DATE_FORMAT.parse(tmp);
                }
                catch (ParseException e1) {
                    try {
                        this.modDate = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(tmp);
                    }
                    catch (ParseException e2) {
                        throw new PrivateProjectException("Bad mod-date: " + e2.getMessage());
                    }
                }
            }
            return c.getRest().accept(this);
        }

        @Override
        public DocFile forEmpty(Empty c) {
            if (this.pathRoot == null || new File(this.fname).isAbsolute()) {
                return new DocFile(this.fname, this.select, this.scroll, this.active, this.pack);
            }
            DocFile f = new DocFile(this.pathRoot, this.fname, this.select, this.scroll, this.active, this.pack);
            if (this.modDate != null) {
                f.setSavedModDate(this.modDate.getTime());
            }
            return f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocFileListVisitor
    implements SEListVisitor<List<DocFile>> {
        private String _base;

        DocFileListVisitor(String base) {
            this._base = base;
        }

        @Override
        public List<DocFile> forEmpty(Empty e) {
            return new ArrayList<DocFile>();
        }

        @Override
        public List<DocFile> forCons(Cons c) {
            List<DocFile> list = c.getRest().accept(this);
            DocFile tmp = ONLY.parseFile(c.getFirst(), this._base);
            list.add(0, tmp);
            return list;
        }
    }
}

