/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.definitions.ColoringView;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.EditDocumentException;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsDJDocument
extends AbstractDJDocument
implements ConsoleDocumentInterface {
    private volatile boolean _hasPrompt = false;
    private volatile boolean _toClear = false;
    private volatile CompoundUndoManager _undoManager;
    private static final int UNDO_LIMIT = 100;
    private volatile boolean _isModifiedSinceSave = false;
    private GlobalEventNotifier _notifier;
    private List<Pair<Pair<Integer, Integer>, String>> _stylesList = new LinkedList<Pair<Pair<Integer, Integer>, String>>();

    public InteractionsDJDocument() {
        this._notifier = new GlobalEventNotifier();
    }

    public InteractionsDJDocument(GlobalEventNotifier notifier) {
        this._notifier = notifier;
        this.resetUndoManager();
    }

    @Override
    public boolean hasPrompt() {
        return this._hasPrompt;
    }

    @Override
    public void setHasPrompt(boolean val) {
        this._hasPrompt = val;
    }

    @Override
    protected void _styleChanged() {
    }

    public CompoundUndoManager getUndoManager() {
        return this._undoManager;
    }

    public void resetUndoManager() {
        this._undoManager = new CompoundUndoManager(this._notifier);
        this._undoManager.setLimit(100);
    }

    public UndoableEdit getNextUndo() {
        return this._undoManager.getNextUndo();
    }

    public UndoableEdit getNextRedo() {
        return this._undoManager.getNextRedo();
    }

    public void documentSaved() {
        this._undoManager.documentSaved();
    }

    @Override
    protected int startCompoundEdit() {
        return this._undoManager.startCompoundEdit();
    }

    @Override
    protected void endCompoundEdit(int key) {
        this._undoManager.endCompoundEdit(key);
    }

    @Override
    protected void endLastCompoundEdit() {
        this._undoManager.endLastCompoundEdit();
    }

    @Override
    protected void addUndoRedo(AbstractDocument.DefaultDocumentEvent chng, Runnable undoCommand, Runnable doCommand) {
        chng.addEdit(new CommandUndoableEdit(undoCommand, doCommand));
    }

    public boolean undoManagerCanUndo() {
        return this._undoManager.canUndo();
    }

    public boolean undoManagerCanRedo() {
        return this._undoManager.canRedo();
    }

    public void updateModifiedSinceSave() {
        this._isModifiedSinceSave = this._undoManager.isModified();
    }

    private void _setModifiedSinceSave() {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        if (!this._isModifiedSinceSave) {
            this._isModifiedSinceSave = true;
        }
    }

    public void resetModification() {
        this._isModifiedSinceSave = false;
        this._undoManager.documentSaved();
    }

    public boolean isModifiedSinceSave() {
        return this._isModifiedSinceSave;
    }

    protected Indenter makeNewIndenter(int indentLevel) {
        return new Indenter(indentLevel);
    }

    @Override
    public void addColoring(int start, int end, String style) {
        if (this._toClear) {
            this._stylesList.clear();
            this._toClear = false;
        }
        if (style != null) {
            this._stylesList.add(0, new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(start, end), style));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Pair<Integer, Integer>, String>[] getStyles() {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            Pair[] result = this._stylesList.toArray(new Pair[0]);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setColoring(int point, Graphics g) {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            for (Pair<Pair<Integer, Integer>, String> p : this._stylesList) {
                Pair<Integer, Integer> loc = p.first();
                if (loc.first() > point || loc.second() < point) continue;
                if (p.second().equals("error")) {
                    g.setColor(ColoringView.ERROR_COLOR);
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.second().equals("debugger")) {
                    g.setColor(ColoringView.DEBUGGER_COLOR);
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.second().equals("System.out")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_OUT_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("System.in")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_IN_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("System.err")) {
                    g.setColor(ColoringView.INTERACTIONS_SYSTEM_ERR_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("object.return.style")) {
                    g.setColor(ColoringView.NORMAL_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("string.return.style")) {
                    g.setColor(ColoringView.DOUBLE_QUOTED_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("number.return.style")) {
                    g.setColor(ColoringView.NUMBER_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else if (p.second().equals("character.return.style")) {
                    g.setColor(ColoringView.SINGLE_QUOTED_COLOR);
                    g.setFont(ColoringView.MAIN_FONT);
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoldFonts(int point, Graphics g) {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            for (Pair<Pair<Integer, Integer>, String> p : this._stylesList) {
                Pair<Integer, Integer> loc = p.first();
                if (loc.first() > point || loc.second() < point) continue;
                if (p.second().equals("error")) {
                    g.setFont(g.getFont().deriveFont(1));
                } else if (p.second().equals("debugger")) {
                    g.setFont(g.getFont().deriveFont(1));
                } else {
                    g.setFont(ColoringView.MAIN_FONT);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearColoring() {
        List<Pair<Pair<Integer, Integer>, String>> list = this._stylesList;
        synchronized (list) {
            this._toClear = true;
        }
    }

    public boolean _inBlockComment() {
        boolean toReturn = this._inBlockComment(this.getLength());
        return toReturn;
    }

    public void appendExceptionResult(String message, String styleName) {
        try {
            this.insertText(this.getLength(), message + "\n", styleName);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    private static class CommandUndoableEdit
    extends AbstractUndoableEdit {
        private final Runnable _undoCommand;
        private final Runnable _redoCommand;

        public CommandUndoableEdit(Runnable undoCommand, Runnable redoCommand) {
            this._undoCommand = undoCommand;
            this._redoCommand = redoCommand;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this._undoCommand.run();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this._redoCommand.run();
        }

        public boolean isSignificant() {
            return false;
        }
    }
}

