/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.request.EventRequest;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DebugAction<T extends EventRequest> {
    public static final int ANY_LINE = -1;
    protected final JPDADebugger _manager;
    protected final Vector<T> _requests;
    protected volatile int _suspendPolicy = 0;
    protected volatile boolean _isEnabled = true;
    protected volatile int _countFilter = -1;
    protected volatile int _lineNumber = -1;

    public DebugAction(JPDADebugger manager) {
        this._manager = manager;
        this._requests = new Vector();
    }

    public Vector<T> getRequests() {
        return this._requests;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public boolean createRequests() throws DebugException {
        this._createRequests();
        if (this._requests.size() > 0) {
            this._prepareRequests(this._requests);
            return true;
        }
        return false;
    }

    protected void _initializeRequests() throws DebugException {
        this.createRequests();
        if (this._requests.size() == 0) {
            throw new DebugException("Could not create EventRequests for this action!");
        }
    }

    protected void _createRequests() throws DebugException {
    }

    protected void _prepareRequests(Vector<T> requests) {
        for (int i = 0; i < requests.size(); ++i) {
            this._prepareRequest((EventRequest)requests.get(i));
        }
    }

    protected void _prepareRequest(T request) {
        request.setEnabled(false);
        if (this._countFilter != -1) {
            request.addCountFilter(this._countFilter);
        }
        request.setSuspendPolicy(this._suspendPolicy);
        request.setEnabled(this._isEnabled);
        request.putProperty("debugAction", this);
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
    }
}

