/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.threadCheck;

import edu.rice.cs.cunit.instrumentors.threadCheck.PredicateAnnotationRecord;
import edu.rice.cs.cunit.threadCheck.OnlyRunBy;
import edu.rice.cs.cunit.threadCheck.SuppressSubtypingWarning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;

public class ThreadCheckAnnotationRecord
implements Serializable {
    public HashSet<String> denyThreadNames;
    public HashSet<Long> denyThreadIds;
    public HashSet<String> denyThreadGroups;
    public HashSet<String> allowThreadNames;
    public HashSet<Long> allowThreadIds;
    public HashSet<String> allowThreadGroups;
    public OnlyRunBy.EVENT_THREAD allowEventThread;
    public ArrayList<PredicateAnnotationRecord> predicateAnnotations;
    public boolean suppressSubtypingWarning = false;
    public long timeStamp;

    public ThreadCheckAnnotationRecord() {
        this.denyThreadNames = new HashSet();
        this.denyThreadIds = new HashSet();
        this.denyThreadGroups = new HashSet();
        this.allowThreadNames = new HashSet();
        this.allowThreadIds = new HashSet();
        this.allowThreadGroups = new HashSet();
        this.allowEventThread = OnlyRunBy.EVENT_THREAD.NO;
        this.predicateAnnotations = new ArrayList();
        this.timeStamp = System.currentTimeMillis();
    }

    public ThreadCheckAnnotationRecord(ThreadCheckAnnotationRecord firstAR, ThreadCheckAnnotationRecord secondAR) {
        this.denyThreadNames = new HashSet<String>(firstAR.denyThreadNames);
        this.denyThreadNames.addAll(secondAR.denyThreadNames);
        this.denyThreadIds = new HashSet<Long>(firstAR.denyThreadIds);
        this.denyThreadIds.addAll(secondAR.denyThreadIds);
        this.denyThreadGroups = new HashSet<String>(firstAR.denyThreadGroups);
        this.denyThreadGroups.addAll(secondAR.denyThreadGroups);
        this.allowThreadNames = new HashSet<String>(firstAR.allowThreadNames);
        this.allowThreadNames.addAll(secondAR.allowThreadNames);
        this.allowThreadIds = new HashSet<Long>(firstAR.allowThreadIds);
        this.allowThreadIds.addAll(secondAR.allowThreadIds);
        this.allowThreadGroups = new HashSet<String>(firstAR.allowThreadGroups);
        this.allowThreadGroups.addAll(secondAR.allowThreadGroups);
        this.allowEventThread = firstAR.allowEventThread.compareTo(secondAR.allowEventThread) >= 0 ? firstAR.allowEventThread : secondAR.allowEventThread;
        this.predicateAnnotations = new ArrayList<PredicateAnnotationRecord>(firstAR.predicateAnnotations);
        this.predicateAnnotations.addAll(this.predicateAnnotations);
        this.timeStamp = Math.max(firstAR.timeStamp, secondAR.timeStamp);
        this.suppressSubtypingWarning = firstAR.suppressSubtypingWarning || secondAR.suppressSubtypingWarning;
    }

    public void add(ThreadCheckAnnotationRecord otherAR) {
        this.denyThreadNames.addAll(otherAR.denyThreadNames);
        this.denyThreadIds.addAll(otherAR.denyThreadIds);
        this.denyThreadGroups.addAll(otherAR.denyThreadGroups);
        this.allowThreadNames.addAll(otherAR.allowThreadNames);
        this.allowThreadIds.addAll(otherAR.allowThreadIds);
        this.allowThreadGroups.addAll(otherAR.allowThreadGroups);
        if (otherAR.allowEventThread.compareTo(this.allowEventThread) > 0) {
            this.allowEventThread = otherAR.allowEventThread;
        }
        this.predicateAnnotations.addAll(otherAR.predicateAnnotations);
        this.timeStamp = Math.max(this.timeStamp, otherAR.timeStamp);
        this.suppressSubtypingWarning = this.suppressSubtypingWarning || otherAR.suppressSubtypingWarning;
    }

    public boolean empty() {
        return this.denyThreadNames.size() == 0 && this.denyThreadIds.size() == 0 && this.denyThreadGroups.size() == 0 && this.allowThreadNames.size() == 0 && this.allowThreadIds.size() == 0 && this.allowThreadGroups.size() == 0 && this.allowEventThread == OnlyRunBy.EVENT_THREAD.NO && this.predicateAnnotations.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadCheckAnnotationRecord that = (ThreadCheckAnnotationRecord)o;
        if (this.suppressSubtypingWarning != that.suppressSubtypingWarning) {
            return false;
        }
        if (this.allowEventThread != that.allowEventThread) {
            return false;
        }
        if (this.allowThreadGroups != null ? !this.allowThreadGroups.equals(that.allowThreadGroups) : that.allowThreadGroups != null) {
            return false;
        }
        if (this.allowThreadIds != null ? !this.allowThreadIds.equals(that.allowThreadIds) : that.allowThreadIds != null) {
            return false;
        }
        if (this.allowThreadNames != null ? !this.allowThreadNames.equals(that.allowThreadNames) : that.allowThreadNames != null) {
            return false;
        }
        if (this.denyThreadGroups != null ? !this.denyThreadGroups.equals(that.denyThreadGroups) : that.denyThreadGroups != null) {
            return false;
        }
        if (this.denyThreadIds != null ? !this.denyThreadIds.equals(that.denyThreadIds) : that.denyThreadIds != null) {
            return false;
        }
        if (this.denyThreadNames != null ? !this.denyThreadNames.equals(that.denyThreadNames) : that.denyThreadNames != null) {
            return false;
        }
        return !(this.predicateAnnotations != null ? !this.predicateAnnotations.equals(that.predicateAnnotations) : that.predicateAnnotations != null);
    }

    public int hashCode() {
        int result = this.denyThreadNames != null ? this.denyThreadNames.hashCode() : 0;
        result = 31 * result + (this.denyThreadIds != null ? this.denyThreadIds.hashCode() : 0);
        result = 31 * result + (this.denyThreadGroups != null ? this.denyThreadGroups.hashCode() : 0);
        result = 31 * result + (this.allowThreadNames != null ? this.allowThreadNames.hashCode() : 0);
        result = 31 * result + (this.allowThreadIds != null ? this.allowThreadIds.hashCode() : 0);
        result = 31 * result + (this.allowThreadGroups != null ? this.allowThreadGroups.hashCode() : 0);
        result = 31 * result + (this.allowEventThread != null ? this.allowEventThread.hashCode() : 0);
        result = 31 * result + (this.predicateAnnotations != null ? this.predicateAnnotations.hashCode() : 0);
        result = 31 * result + (this.suppressSubtypingWarning ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.empty()) {
            return "";
        }
        String LF = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        if (this.suppressSubtypingWarning) {
            sb.append('@');
            sb.append(SuppressSubtypingWarning.class.getSimpleName());
            sb.append(LF);
        }
        if (this.denyThreadNames.size() > 0 || this.denyThreadGroups.size() > 0 || this.denyThreadIds.size() > 0) {
            StringBuilder sbNot = new StringBuilder();
            for (String s : this.denyThreadNames) {
                sbNot.append(',');
                sbNot.append(LF);
                sbNot.append("\t@ThreadDesc(name=\"");
                sbNot.append(s);
                sbNot.append("\")");
            }
            for (String s : this.denyThreadGroups) {
                sbNot.append(',');
                sbNot.append(LF);
                sbNot.append("\t@ThreadDesc(group=\"");
                sbNot.append(s);
                sbNot.append("\")");
            }
            for (Long l : this.denyThreadIds) {
                sbNot.append(',');
                sbNot.append(LF);
                sbNot.append("\t@ThreadDesc(id=");
                sbNot.append(l);
                sbNot.append(")");
            }
            sbNot.append(LF);
            sbNot.append("})");
            sbNot.deleteCharAt(0);
            sb.append("@NotRunBy({");
            sb.append(sbNot.toString());
        }
        if (this.allowThreadNames.size() > 0 || this.allowThreadGroups.size() > 0 || this.allowThreadIds.size() > 0 || this.allowEventThread != OnlyRunBy.EVENT_THREAD.NO) {
            if (sb.length() > 0) {
                sb.append(LF);
            }
            StringBuilder sbOnly = new StringBuilder();
            for (String s : this.allowThreadNames) {
                sbOnly.append(',');
                sbOnly.append(LF);
                sbOnly.append("\t@ThreadDesc(name=\"");
                sbOnly.append(s);
                sbOnly.append("\")");
            }
            for (String s : this.allowThreadGroups) {
                sbOnly.append(',');
                sbOnly.append(LF);
                sbOnly.append("\t@ThreadDesc(group=\"");
                sbOnly.append(s);
                sbOnly.append("\")");
            }
            for (Long l : this.allowThreadIds) {
                sbOnly.append(',');
                sbOnly.append(LF);
                sbOnly.append("\t@ThreadDesc(id=");
                sbOnly.append(l);
                sbOnly.append(")");
            }
            if (this.allowEventThread == OnlyRunBy.EVENT_THREAD.ONLY) {
                sbOnly.append(',');
                sbOnly.append(LF);
                sbOnly.append("\t@ThreadDesc(eventThread=OnlyRunBy.EVENT_THREAD.ONLY)");
            } else if (this.allowEventThread == OnlyRunBy.EVENT_THREAD.ONLY_AFTER_REALIZED) {
                sbOnly.append(',');
                sbOnly.append(LF);
                sbOnly.append("\t@ThreadDesc(eventThread=OnlyRunBy.EVENT_THREAD.ONLY_AFTER_REALIZED)");
            }
            sbOnly.append(LF);
            sbOnly.append("})");
            sbOnly.deleteCharAt(0);
            sb.append("@OnlyRunBy({");
            sb.append(sbOnly.toString());
        }
        if (this.predicateAnnotations.size() > 0) {
            if (sb.length() > 0) {
                sb.append(LF);
            }
            boolean notFirst = false;
            for (PredicateAnnotationRecord pa : this.predicateAnnotations) {
                if (notFirst) {
                    sb.append(LF);
                } else {
                    notFirst = true;
                }
                sb.append(pa.toString());
            }
        }
        return sb.toString();
    }
}

