/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.tree.Allocation;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.IntType;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.VariableDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclaration
extends ClassDeclaration {
    public EnumDeclaration(int flags, String name, List<? extends ReferenceType> impl, EnumBody body) {
        this(flags, name, impl, body, null, 0, 0, 0, 0);
    }

    public EnumDeclaration(int flags, String name, List<? extends ReferenceType> impl, EnumBody body, String fn, int bl, int bc, int el, int ec) {
        super(flags, name, new ReferenceType("java.lang.Enum"), impl, EnumDeclaration.AddValues(name, EnumDeclaration.HandleConstructors(name, EnumDeclaration.makeEnumBodyDeclarationsFromEnumConsts(name, body)), body.getConstants()), fn, bl, bc, el, ec);
    }

    static List<Node> AddValues(String enumTypeName, List<Node> body, List<EnumConstant> consts) {
        String[] consts_names = new String[consts.size()];
        for (int i = 0; i < consts_names.length; ++i) {
            consts_names[i] = consts.get(i).getName();
        }
        List<Node> newbody = body;
        int accessFlags = 26;
        ReferenceType enumType = new ReferenceType(enumTypeName);
        ArrayType valuesType = new ArrayType(enumType, 1);
        LinkedList<Expression> sizes = new LinkedList<Expression>();
        sizes.add(new IntegerLiteral(String.valueOf(consts_names.length)));
        LinkedList<Expression> cells = new LinkedList<Expression>();
        for (int i = 0; i < consts_names.length; ++i) {
            cells.add(new StaticFieldAccess(enumType, consts_names[i]));
        }
        ArrayAllocation allocExpr = new ArrayAllocation(enumType, new ArrayAllocation.TypeDescriptor(sizes, 1, new ArrayInitializer(cells), 0, 0));
        newbody.add(new FieldDeclaration(accessFlags, valuesType, "$VALUES", allocExpr));
        accessFlags = 25;
        LinkedList<FormalParameter> vparams = new LinkedList<FormalParameter>();
        LinkedList<Node> stmts = new LinkedList<Node>();
        stmts.add(new ReturnStatement(new CastExpression(enumType, new ObjectMethodCall(new StaticFieldAccess(enumType, "$VALUES"), "clone", null))));
        newbody.add(new MethodDeclaration(accessFlags, valuesType, "values", vparams, new LinkedList(), new BlockStatement(stmts)));
        LinkedList<FormalParameter> voparams = new LinkedList<FormalParameter>();
        voparams.add(new FormalParameter(false, new ReferenceType("String"), "s"));
        accessFlags = 9;
        LinkedList<Node> stmtsOf = new LinkedList<Node>();
        LinkedList<Node> init = new LinkedList<Node>();
        init.add(new VariableDeclaration(false, new IntType(), "i", new IntegerLiteral("0")));
        LinkedList<IdentifierToken> iIds = new LinkedList<IdentifierToken>();
        iIds.add(new Identifier("i"));
        QualifiedName iId = new QualifiedName(iIds);
        LessExpression cond = new LessExpression(iId, new ObjectFieldAccess(new StaticFieldAccess(enumType, "$VALUES"), "length"));
        LinkedList<Node> updt = new LinkedList<Node>();
        updt.add(new PostIncrement(iId));
        ArrayAccess arrCell = new ArrayAccess(new StaticFieldAccess(enumType, "$VALUES"), iId);
        LinkedList<Expression> args = new LinkedList<Expression>();
        LinkedList<IdentifierToken> sIds = new LinkedList<IdentifierToken>();
        sIds.add(new Identifier("s"));
        QualifiedName sId = new QualifiedName(sIds);
        args.add(new QualifiedName(sIds));
        IfThenStatement bodyOf = new IfThenStatement(new ObjectMethodCall(new ObjectMethodCall(arrCell, "name", null), "equals", args), new ReturnStatement(arrCell));
        stmtsOf.add(new ForStatement(init, cond, updt, bodyOf));
        stmtsOf.add(new ThrowStatement(new SimpleAllocation(new ReferenceType("IllegalArgumentException"), args)));
        newbody.add(new MethodDeclaration(accessFlags, enumType, "valueOf", voparams, new LinkedList(), new BlockStatement(stmtsOf)));
        return newbody;
    }

    static List<Node> HandleConstructors(String name, List<Node> body) {
        ListIterator<Node> it = body.listIterator();
        LinkedList<IdentifierToken> idnt1 = new LinkedList<IdentifierToken>();
        idnt1.add(new Identifier("$1"));
        LinkedList<IdentifierToken> idnt2 = new LinkedList<IdentifierToken>();
        idnt2.add(new Identifier("$2"));
        LinkedList<FormalParameter> addToConsDeclaration = new LinkedList<FormalParameter>();
        addToConsDeclaration.add(new FormalParameter(false, new ReferenceType("String"), "$1"));
        addToConsDeclaration.add(new FormalParameter(false, new IntType(), "$2"));
        LinkedList<Expression> args = new LinkedList<Expression>();
        args.add(new QualifiedName(idnt1));
        args.add(new QualifiedName(idnt2));
        boolean noConstructor = true;
        while (it.hasNext()) {
            Node current = (Node)it.next();
            if (!(current instanceof ConstructorDeclaration)) continue;
            noConstructor = false;
            List<FormalParameter> consParams = ((ConstructorDeclaration)current).getParameters();
            LinkedList<FormalParameter> newConsParam = new LinkedList<FormalParameter>();
            newConsParam.addAll(addToConsDeclaration);
            newConsParam.addAll(consParams);
            ((ConstructorDeclaration)current).setParameters(newConsParam);
            ((ConstructorDeclaration)current).setConstructorInvocation(new ConstructorInvocation(null, args, true));
        }
        if (noConstructor) {
            body.add(new ConstructorDeclaration(2, name, addToConsDeclaration, new LinkedList(), new ConstructorInvocation(null, args, true), new LinkedList<Node>()));
        }
        return body;
    }

    static List<Node> makeEnumBodyDeclarationsFromEnumConsts(String enumTypeName, EnumBody body) {
        List<EnumConstant> consts = body.getConstants();
        List<Node> decls = body.getDeclarations();
        int accessFlags = 1;
        accessFlags |= 8;
        accessFlags |= 0x10;
        accessFlags |= 0x4000;
        ReferenceType enumType = new ReferenceType(enumTypeName);
        Allocation allocExpr = null;
        ListIterator<EnumConstant> it = consts.listIterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedList<Expression> args = new LinkedList<Expression>();
            EnumConstant ec = (EnumConstant)it.next();
            args.add(new StringLiteral(new StringBuffer().append("\"").append(ec.getName()).append("\"").toString()));
            args.add(new IntegerLiteral(String.valueOf(i++)));
            if (ec.getArguments() != null) {
                args.addAll(ec.getArguments());
            }
            allocExpr = ec.getClassBody() != null ? new ClassAllocation(enumType, args, ec.getClassBody()) : new SimpleAllocation(enumType, args);
            decls.add(new FieldDeclaration(accessFlags, enumType, ec.getName(), allocExpr));
        }
        return decls;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumBody {
        private List<EnumConstant> consts;
        private List<Node> decls;

        public EnumBody(List<EnumConstant> c, List<Node> d) {
            this.consts = c;
            this.decls = d;
        }

        List<EnumConstant> getConstants() {
            return this.consts;
        }

        List<Node> getDeclarations() {
            return this.decls;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumConstant {
        String name;
        List<Expression> args;
        List<Node> classBody;

        public EnumConstant(String _name, List<Expression> _args, List<Node> _classBody) {
            this.name = _name;
            this.args = _args;
            this.classBody = _classBody;
        }

        String getName() {
            return this.name;
        }

        List<Expression> getArguments() {
            return this.args;
        }

        List<Node> getClassBody() {
            return this.classBody;
        }
    }
}

