/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.interpreter.ClassPool;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.util.ImportationManager;

public class TreeClassFinder
implements ClassFinder {
    protected Context context;
    protected Interpreter interpreter;
    protected ClassPool classPool;

    public TreeClassFinder(Context ctx, Interpreter i, ClassPool cp) {
        this.context = ctx;
        this.interpreter = i;
        this.classPool = cp;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public String getCurrentPackage() {
        return this.context.getCurrentPackage();
    }

    public ImportationManager getImportationManager() {
        return this.context.getImportationManager();
    }

    public ClassInfo lookupClass(String cname) throws ClassNotFoundException {
        if (this.classPool.contains(cname)) {
            return this.classPool.get(cname);
        }
        try {
            return new JavaClassInfo(this.context.lookupClass(cname, null));
        }
        catch (TreeCompiler.PseudoError e) {
            return e.getClassInfo();
        }
    }

    public ClassInfo lookupClass(String cname, ClassInfo cinfo) throws ClassNotFoundException {
        String name = cinfo.getName();
        if (this.classPool.contains(cname)) {
            return this.classPool.get(cname);
        }
        String s = name + "$" + cname;
        if (this.classPool.contains(s)) {
            return this.classPool.get(s);
        }
        try {
            return new JavaClassInfo(this.context.lookupClass(cname, name));
        }
        catch (ClassNotFoundException e) {
            ClassInfo ci = cinfo.getDeclaringClass();
            try {
                if (ci != null) {
                    return new JavaClassInfo(this.context.lookupClass(ci.getName() + "$" + cname));
                }
                throw new ClassNotFoundException(cname);
            }
            catch (ClassNotFoundException ex) {
                ci = cinfo;
                while ((ci = ci.getSuperclass()) != null) {
                    try {
                        return new JavaClassInfo(this.context.lookupClass(ci.getName() + "$" + cname));
                    }
                    catch (ClassNotFoundException e2) {
                    }
                    catch (TreeCompiler.PseudoError e2) {
                        return e2.getClassInfo();
                    }
                }
            }
            catch (TreeCompiler.PseudoError ex) {
                return ex.getClassInfo();
            }
        }
        catch (TreeCompiler.PseudoError e) {
            return e.getClassInfo();
        }
        throw new ClassNotFoundException(cname);
    }

    public ClassInfo addClassInfo(String cname, TypeDeclaration decl) {
        return this.classPool.add(cname, new TreeClassInfo(decl, this));
    }
}

