/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import koala.dynamicjava.SourceInfo;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.tree.Node;

public class InterpreterException
extends ThrownException {
    protected SourceInfo sourceInfo;
    protected String message;

    public InterpreterException(ParseError e) {
        super(e);
        this.message = e.getLine() != -1 ? "L" + e.getLine() + ", C" + e.getColumn() + " (" + e.getFilename() + "):\n" + e.getMessage() : e.getMessage();
    }

    public InterpreterException(ExecutionError e) {
        super(e);
        Node n = e.getNode();
        if (n != null && n.getFilename() != null) {
            SourceInfo si = n.getSourceInfo();
            this.message = "BL" + si.getStartLine() + ", BC" + si.getStartColumn() + "EL" + si.getEndLine() + ", EC" + si.getEndColumn() + " (" + si.getFile().getName() + "):\n";
        } else {
            this.message = "";
        }
        this.message = e instanceof CatchedExceptionError ? this.message + ((CatchedExceptionError)e).getException() : (e instanceof ThrownException ? this.message + ((ThrownException)e).getException() : this.message + e.getMessage());
    }

    public Throwable getError() {
        return this.thrown;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public String getMessage() {
        return this.message;
    }
}

