/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import koala.dynamicjava.classfile.ClassFile;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.CodeAttribute;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ConstantString;
import koala.dynamicjava.classfile.ExceptionsAttribute;
import koala.dynamicjava.classfile.FieldInfo;
import koala.dynamicjava.classfile.InnerClassesAttribute;
import koala.dynamicjava.classfile.InnerClassesEntry;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodIdentifier;
import koala.dynamicjava.classfile.MethodInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactory
extends ClassFile {
    private static final String VOID_NAME = JVMUtilities.getName("void");
    private static final String BOOLEAN_NAME = JVMUtilities.getName("boolean");
    private static final String CHAR_NAME = JVMUtilities.getName("char");
    private static final String INT_NAME = JVMUtilities.getName("int");
    private static final String LONG_NAME = JVMUtilities.getName("long");
    private static final String FLOAT_NAME = JVMUtilities.getName("float");
    private static final String DOUBLE_NAME = JVMUtilities.getName("double");
    private static final String BYTE_NAME = JVMUtilities.getName("byte");
    private static final String SHORT_NAME = JVMUtilities.getName("short");
    private static final String OBJECT_NAME = JVMUtilities.getName("java.lang.Object");
    private static final String BOOLEAN_WRAPPER_NAME = JVMUtilities.getName("java.lang.Boolean");
    private static final String CHAR_WRAPPER_NAME = JVMUtilities.getName("java.lang.Character");
    private static final String INT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Integer");
    private static final String LONG_WRAPPER_NAME = JVMUtilities.getName("java.lang.Long");
    private static final String FLOAT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Float");
    private static final String DOUBLE_WRAPPER_NAME = JVMUtilities.getName("java.lang.Double");
    private static final String BYTE_WRAPPER_NAME = JVMUtilities.getName("java.lang.Byte");
    private static final String SHORT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Short");
    private static final String NUMBER_NAME = JVMUtilities.getName("java.lang.Number");
    private static final ClassIdentifier BOOLEAN_IDENTIFIER = new ClassIdentifier(BOOLEAN_WRAPPER_NAME);
    private static final MethodIdentifier BOOLEAN_CONSTRUCTOR = new MethodIdentifier(BOOLEAN_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{BOOLEAN_NAME});
    private static final ClassIdentifier CHARACTER_IDENTIFIER = new ClassIdentifier(CHAR_WRAPPER_NAME);
    private static final MethodIdentifier CHARACTER_CONSTRUCTOR = new MethodIdentifier(CHAR_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{CHAR_NAME});
    private static final ClassIdentifier INTEGER_IDENTIFIER = new ClassIdentifier(INT_WRAPPER_NAME);
    private static final MethodIdentifier INTEGER_CONSTRUCTOR = new MethodIdentifier(INT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{INT_NAME});
    private static final ClassIdentifier LONG_IDENTIFIER = new ClassIdentifier(LONG_WRAPPER_NAME);
    private static final MethodIdentifier LONG_CONSTRUCTOR = new MethodIdentifier(LONG_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{LONG_NAME});
    private static final ClassIdentifier FLOAT_IDENTIFIER = new ClassIdentifier(FLOAT_WRAPPER_NAME);
    private static final MethodIdentifier FLOAT_CONSTRUCTOR = new MethodIdentifier(FLOAT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{FLOAT_NAME});
    private static final ClassIdentifier DOUBLE_IDENTIFIER = new ClassIdentifier(DOUBLE_WRAPPER_NAME);
    private static final MethodIdentifier DOUBLE_CONSTRUCTOR = new MethodIdentifier(DOUBLE_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{DOUBLE_NAME});
    private static final ClassIdentifier BYTE_IDENTIFIER = new ClassIdentifier(BYTE_WRAPPER_NAME);
    private static final MethodIdentifier BYTE_CONSTRUCTOR = new MethodIdentifier(BYTE_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{BYTE_NAME});
    private static final ClassIdentifier SHORT_IDENTIFIER = new ClassIdentifier(SHORT_WRAPPER_NAME);
    private static final MethodIdentifier SHORT_CONSTRUCTOR = new MethodIdentifier(SHORT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{SHORT_NAME});
    private static final ClassIdentifier OBJECT_IDENTIFIER = new ClassIdentifier(OBJECT_NAME);
    private static final ClassIdentifier NUMBER_IDENTIFIER = new ClassIdentifier(NUMBER_NAME);
    private static final MethodIdentifier BOOLEAN_BOOLEAN_VALUE_METHOD = new MethodIdentifier(BOOLEAN_WRAPPER_NAME, "booleanValue", BOOLEAN_NAME, new String[0]);
    private static final MethodIdentifier CHARACTER_CHAR_VALUE_METHOD = new MethodIdentifier(CHAR_WRAPPER_NAME, "charValue", CHAR_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_INT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "intValue", INT_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_LONG_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "longValue", LONG_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_FLOAT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "floatValue", FLOAT_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_DOUBLE_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "doubleValue", DOUBLE_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_BYTE_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "byteValue", BYTE_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_SHORT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "shortValue", SHORT_NAME, new String[0]);
    private String name;
    private String superName;
    private boolean isStaticClass;
    private MethodIdentifier interpreterMethod;
    private MethodIdentifier interpretArgumentsMethod;
    private MethodIdentifier thrownExceptionMethod;
    private String thrownExceptionName;
    private InnerClassesAttribute innerClassesAttribute;
    private String classLoaderId;

    public ClassFactory(int af, String name, String sname, Class<?> interp, Class<?> except, String clid) {
        super(name, sname);
        this.name = name;
        this.superName = sname;
        this.classLoaderId = clid;
        this.isStaticClass = (af & 8) != 0;
        int taf = af & 0xFFFFFFFD & 0xFFFFFFFB & 0xFFFFFFF7;
        this.setAccessFlags(taf | 0x20 | (this.isStaticClass ? 1 : 0));
        String interpClassName = interp.getName();
        this.interpreterMethod = new MethodIdentifier(JVMUtilities.getName(interpClassName), "invokeMethod", JVMUtilities.getReturnTypeName("java.lang.Object"), new String[]{JVMUtilities.getParameterTypeName("java.lang.String"), JVMUtilities.getParameterTypeName("java.lang.Object"), JVMUtilities.getParameterTypeName("java.lang.Object[]")});
        this.interpretArgumentsMethod = new MethodIdentifier(JVMUtilities.getName(interpClassName), "interpretArguments", JVMUtilities.getReturnTypeName("java.lang.Object[]"), new String[]{JVMUtilities.getParameterTypeName("java.lang.String"), JVMUtilities.getParameterTypeName("java.lang.Object[]")});
        this.thrownExceptionName = except.getName();
        this.thrownExceptionMethod = new MethodIdentifier(JVMUtilities.getName(this.thrownExceptionName), "getException", JVMUtilities.getReturnTypeName("java.lang.Exception"), new String[0]);
    }

    public static String getMethodIdentifier(String cname, String mname, String[] pnames, String clid) {
        String result = new StringBuffer().append(cname).append("#").append(mname).append("(").toString();
        if (pnames.length > 0) {
            result = new StringBuffer().append(result).append(pnames[0]).toString();
        }
        for (int i = 1; i < pnames.length; ++i) {
            result = new StringBuffer().append(result).append(",").append(pnames[i]).toString();
        }
        return new StringBuffer().append(result).append(")").append(clid).toString();
    }

    public String createClassInitializer() {
        try {
            MethodInfo mi = this.createMethod("void", "<clinit>", new String[0]);
            String result = ClassFactory.getMethodIdentifier(this.name, "<clinit>", new String[0], this.classLoaderId);
            mi.setAccessFlags(8);
            ConstantPool cp = this.getConstantPool();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            this.bipush(0, data);
            data.writeByte(189);
            short s = cp.put(OBJECT_IDENTIFIER);
            data.writeShort(s);
            this.astore(0, data);
            s = cp.put(new ConstantString(result));
            if (s > 256) {
                data.writeByte(19);
                data.writeShort(s);
            } else {
                data.writeByte(18);
                data.writeByte(s);
            }
            data.writeByte(1);
            this.aload(0, data);
            data.writeByte(184);
            data.writeShort(cp.put(this.interpreterMethod));
            data.writeByte(177);
            CodeAttribute ca = mi.createCodeAttribute();
            ca.setCode(bytes.toByteArray(), (short)1, (short)6);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String addConstructor(int af, String[] pt, String[] ex, String sup, String[] st) {
        try {
            String a;
            int i;
            String result = ClassFactory.getMethodIdentifier(this.name, "<init>", pt, this.classLoaderId);
            MethodInfo mi = this.createMethod("void", "<init>", pt);
            mi.setAccessFlags(af);
            ConstantPool cp = this.getConstantPool();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            short maxStack = 6;
            short maxLocals = 3;
            for (int i2 = 0; i2 < pt.length; ++i2) {
                String s = pt[i2];
                maxLocals = s.equals("long") || s.equals("double") ? (short)((short)(maxLocals + 2)) : (short)((short)(maxLocals + 1));
            }
            short variablesStart = maxLocals;
            for (int i3 = 0; i3 < st.length; ++i3) {
                String s = st[i3];
                if (s.equals("long") || s.equals("double")) {
                    maxLocals = (short)(maxLocals + 2);
                    maxStack = (short)(maxStack + 2);
                    continue;
                }
                maxLocals = (short)(maxLocals + 1);
                maxStack = (short)(maxStack + 1);
            }
            this.bipush(pt.length, data);
            data.writeByte(189);
            short s = cp.put(OBJECT_IDENTIFIER);
            data.writeShort(s);
            if (variablesStart < 5) {
                data.writeByte(75 + variablesStart - 1);
            } else {
                data.writeByte(58);
                data.writeByte(variablesStart - 1);
            }
            short currentLocal = 1;
            for (int i4 = 0; i4 < pt.length; ++i4) {
                String a2 = pt[i4];
                this.aload(variablesStart - 1, data);
                this.bipush(i4, data);
                if (a2.equals("int")) {
                    this.loadInt(currentLocal, data, cp);
                } else if (a2.equals("long")) {
                    this.loadLong(currentLocal, data, cp);
                    ++currentLocal;
                } else if (a2.equals("float")) {
                    this.loadFloat(currentLocal, data, cp);
                } else if (a2.equals("double")) {
                    this.loadDouble(currentLocal, data, cp);
                    ++currentLocal;
                } else if (a2.equals("byte")) {
                    this.loadByte(currentLocal, data, cp);
                } else if (a2.equals("short")) {
                    this.loadShort(currentLocal, data, cp);
                } else if (a2.equals("boolean")) {
                    this.loadBoolean(currentLocal, data, cp);
                } else if (a2.equals("char")) {
                    this.loadChar(currentLocal, data, cp);
                } else {
                    this.aload(currentLocal, data);
                }
                data.writeByte(83);
                ++currentLocal;
            }
            short tryStart = (short)data.size();
            s = cp.put(new ConstantString(result));
            if (s > 256) {
                data.writeByte(19);
                data.writeShort(s);
            } else {
                data.writeByte(18);
                data.writeByte(s);
            }
            this.aload(variablesStart - 1, data);
            data.writeByte(184);
            data.writeShort(cp.put(this.interpretArgumentsMethod));
            this.astore(variablesStart - 2, data);
            currentLocal = variablesStart;
            for (i = 0; i < st.length; ++i) {
                a = st[i];
                this.aload(variablesStart - 2, data);
                this.bipush(i, data);
                data.writeByte(50);
                if (a.equals("int")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_INT_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(59 + currentLocal);
                    } else {
                        data.writeByte(54);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("long")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_LONG_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(63 + currentLocal);
                    } else {
                        data.writeByte(55);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("float")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_FLOAT_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(67 + currentLocal);
                    } else {
                        data.writeByte(56);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("double")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_DOUBLE_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(71 + currentLocal);
                    } else {
                        data.writeByte(57);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("byte")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_BYTE_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(59 + currentLocal);
                    } else {
                        data.writeByte(54);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("short")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_SHORT_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(59 + currentLocal);
                    } else {
                        data.writeByte(54);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("boolean")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(BOOLEAN_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(BOOLEAN_BOOLEAN_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(59 + currentLocal);
                    } else {
                        data.writeByte(54);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("char")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(CHARACTER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(CHARACTER_CHAR_VALUE_METHOD));
                    if (currentLocal < 4) {
                        data.writeByte(59 + currentLocal);
                    } else {
                        data.writeByte(54);
                        data.writeByte(currentLocal);
                    }
                } else {
                    this.astore(currentLocal, data);
                }
                ++currentLocal;
            }
            data.writeByte(42);
            currentLocal = variablesStart;
            for (i = 0; i < st.length; ++i) {
                a = st[i];
                if (a.equals("int")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("long")) {
                    if (currentLocal < 4) {
                        data.writeByte(30 + currentLocal);
                    } else {
                        data.writeByte(22);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("float")) {
                    if (currentLocal < 4) {
                        data.writeByte(34 + currentLocal);
                    } else {
                        data.writeByte(23);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("double")) {
                    if (currentLocal < 4) {
                        data.writeByte(38 + currentLocal);
                    } else {
                        data.writeByte(24);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("byte")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("short")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("boolean")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("char")) {
                    this.iload(currentLocal, data);
                } else {
                    this.aload(currentLocal, data);
                    data.writeByte(192);
                    data.writeShort(cp.put(new ClassIdentifier(JVMUtilities.getName(st[i]))));
                }
                ++currentLocal;
            }
            data.writeByte(183);
            for (i = 0; i < st.length; ++i) {
                st[i] = JVMUtilities.getParameterTypeName(st[i]);
            }
            MethodIdentifier mid = new MethodIdentifier(JVMUtilities.getName(sup), "<init>", JVMUtilities.getName("void"), st);
            data.writeShort(cp.put(mid));
            s = cp.put(new ConstantString(result));
            if (s > 256) {
                data.writeByte(19);
                data.writeShort(s);
            } else {
                data.writeByte(18);
                data.writeByte(s);
            }
            data.writeByte(42);
            this.aload(variablesStart - 1, data);
            data.writeByte(184);
            data.writeShort(cp.put(this.interpreterMethod));
            data.writeByte(177);
            short tryEnd = (short)data.size();
            if (ex.length > 0) {
                maxLocals = (short)(maxLocals + 2);
                this.astore(maxLocals - 2, data);
                this.aload(maxLocals - 2, data);
                data.writeByte(182);
                data.writeShort(cp.put(this.thrownExceptionMethod));
                this.astore(maxLocals - 1, data);
                for (int i5 = 0; i5 < ex.length; ++i5) {
                    this.aload(maxLocals - 1, data);
                    data.writeByte(193);
                    s = cp.put(new ClassIdentifier(JVMUtilities.getName(ex[i5])));
                    data.writeShort(s);
                    data.writeByte(153);
                    if (maxLocals < 5) {
                        data.writeShort(8);
                    } else {
                        data.writeShort(9);
                    }
                    this.aload(maxLocals - 1, data);
                    data.writeByte(192);
                    data.writeShort(s);
                    data.writeByte(191);
                }
                this.aload(maxLocals - 2, data);
                data.writeByte(191);
            }
            CodeAttribute ca = mi.createCodeAttribute();
            ca.setCode(bytes.toByteArray(), maxLocals, maxStack);
            if (ex.length > 0) {
                ca.addExceptionTableEntry(tryStart, tryEnd, tryEnd, this.thrownExceptionName);
            }
            if (ex.length > 0) {
                ExceptionsAttribute ea = mi.createExceptionsAttribute();
                for (int i6 = 0; i6 < ex.length; ++i6) {
                    ea.addException(ex[i6]);
                }
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addField(int af, String ft, String nm) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
    }

    public void addConstantIntField(int af, String ft, String nm, Integer v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(v);
    }

    public void addConstantLongField(int af, String ft, String nm, Long v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(v);
    }

    public void addConstantFloatField(int af, String ft, String nm, Float v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(v);
    }

    public void addConstantDoubleField(int af, String ft, String nm, Double v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(v);
    }

    public void addConstantBooleanField(int af, String ft, String nm, Boolean v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(new Integer(v != false ? 1 : 0));
    }

    public void addConstantStringField(int af, String ft, String nm, String v) {
        FieldInfo fi = this.createField(ft, nm);
        fi.setAccessFlags(af);
        fi.setConstantValueAttribute(v);
    }

    public InnerClassesEntry addInnerClassesEntry() {
        if (this.innerClassesAttribute == null) {
            this.innerClassesAttribute = new InnerClassesAttribute(this.getConstantPool());
            this.setInnerClassesAttribute(this.innerClassesAttribute);
        }
        return this.innerClassesAttribute.addInnerClassesEntry();
    }

    public void addSuperMethodAccessor(int af, String rt, String nm, String[] pt, String[] ex) {
        try {
            MethodInfo mi = this.createMethod(rt, new StringBuffer().append("super$").append(nm).toString(), pt);
            mi.setAccessFlags(1);
            ConstantPool cp = this.getConstantPool();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            boolean isStatic = Modifier.isStatic(af);
            short maxLocals = (short)(isStatic ? 1 : 2);
            for (int i = 0; i < pt.length; ++i) {
                String s = pt[i];
                maxLocals = s.equals("long") || s.equals("double") ? (short)(maxLocals + 2) : (short)(maxLocals + 1);
            }
            short maxStack = maxLocals;
            int currentLocal = 0;
            if (!isStatic) {
                data.writeByte(42);
                currentLocal = 1;
            }
            for (int i = 0; i < pt.length; ++i) {
                String a = pt[i];
                if (a.equals("int")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("long")) {
                    if (currentLocal < 4) {
                        data.writeByte(30 + currentLocal);
                    } else {
                        data.writeByte(22);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("float")) {
                    if (currentLocal < 4) {
                        data.writeByte(34 + currentLocal);
                    } else {
                        data.writeByte(23);
                        data.writeByte(currentLocal);
                    }
                } else if (a.equals("double")) {
                    if (currentLocal < 4) {
                        data.writeByte(38 + currentLocal);
                    } else {
                        data.writeByte(24);
                        data.writeByte(currentLocal);
                    }
                    ++currentLocal;
                } else if (a.equals("byte")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("short")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("boolean")) {
                    this.iload(currentLocal, data);
                } else if (a.equals("char")) {
                    this.iload(currentLocal, data);
                } else {
                    this.aload(currentLocal, data);
                    data.writeByte(192);
                    data.writeShort(cp.put(new ClassIdentifier(JVMUtilities.getName(pt[i]))));
                }
                ++currentLocal;
            }
            String[] st = new String[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                st[i] = JVMUtilities.getParameterTypeName(pt[i]);
            }
            MethodIdentifier mid = new MethodIdentifier(JVMUtilities.getName(this.superName), nm, JVMUtilities.getReturnTypeName(rt), st);
            if (isStatic) {
                data.writeByte(184);
            } else {
                data.writeByte(183);
            }
            data.writeShort(cp.put(mid));
            if (rt.equals("void")) {
                data.writeByte(177);
            } else if (rt.equals("int")) {
                data.writeByte(172);
            } else if (rt.equals("long")) {
                data.writeByte(173);
            } else if (rt.equals("float")) {
                data.writeByte(174);
            } else if (rt.equals("double")) {
                data.writeByte(175);
            } else if (rt.equals("byte")) {
                data.writeByte(172);
            } else if (rt.equals("short")) {
                data.writeByte(172);
            } else if (rt.equals("boolean")) {
                data.writeByte(172);
            } else if (rt.equals("char")) {
                data.writeByte(172);
            } else {
                data.writeByte(176);
            }
            CodeAttribute ca = mi.createCodeAttribute();
            ca.setCode(bytes.toByteArray(), maxLocals, maxStack);
            if (ex.length > 0) {
                ExceptionsAttribute ea = mi.createExceptionsAttribute();
                for (int i = 0; i < ex.length; ++i) {
                    ea.addException(ex[i]);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String addMethod(int af, String rt, String nm, String[] pt, String[] ex) {
        try {
            MethodInfo mi = this.createMethod(rt, nm, pt);
            String result = ClassFactory.getMethodIdentifier(this.name, nm, pt, this.classLoaderId);
            mi.setAccessFlags(af);
            if (!mi.isAbstract()) {
                ConstantPool cp = this.getConstantPool();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(bytes);
                short maxStack = 6;
                short maxLocals = (short)(mi.isStatic() ? 1 : 2);
                for (int i = 0; i < pt.length; ++i) {
                    String s = pt[i];
                    maxLocals = s.equals("long") || s.equals("double") ? (short)(maxLocals + 2) : (short)(maxLocals + 1);
                }
                this.bipush(pt.length, data);
                data.writeByte(189);
                short s = cp.put(OBJECT_IDENTIFIER);
                data.writeShort(s);
                this.astore(maxLocals - 1, data);
                int currentLocal = mi.isStatic() ? 0 : 1;
                for (int i = 0; i < pt.length; ++i) {
                    String a = pt[i];
                    this.aload(maxLocals - 1, data);
                    this.bipush(i, data);
                    if (a.equals("int")) {
                        this.loadInt(currentLocal, data, cp);
                    } else if (a.equals("long")) {
                        this.loadLong(currentLocal, data, cp);
                        ++currentLocal;
                    } else if (a.equals("float")) {
                        this.loadFloat(currentLocal, data, cp);
                    } else if (a.equals("double")) {
                        this.loadDouble(currentLocal, data, cp);
                        ++currentLocal;
                    } else if (a.equals("byte")) {
                        this.loadByte(currentLocal, data, cp);
                    } else if (a.equals("short")) {
                        this.loadShort(currentLocal, data, cp);
                    } else if (a.equals("boolean")) {
                        this.loadBoolean(currentLocal, data, cp);
                    } else if (a.equals("char")) {
                        this.loadChar(currentLocal, data, cp);
                    } else {
                        this.aload(currentLocal, data);
                    }
                    data.writeByte(83);
                    ++currentLocal;
                }
                short tryStart = (short)data.size();
                s = cp.put(new ConstantString(result));
                if (s > 256) {
                    data.writeByte(19);
                    data.writeShort(s);
                } else {
                    data.writeByte(18);
                    data.writeByte(s);
                }
                if (mi.isStatic()) {
                    data.writeByte(1);
                } else {
                    data.writeByte(42);
                }
                this.aload(maxLocals - 1, data);
                data.writeByte(184);
                data.writeShort(cp.put(this.interpreterMethod));
                if (rt.equals("void")) {
                    data.writeByte(177);
                } else if (rt.equals("int")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_INT_VALUE_METHOD));
                    data.writeByte(172);
                } else if (rt.equals("long")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_LONG_VALUE_METHOD));
                    data.writeByte(173);
                } else if (rt.equals("float")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_FLOAT_VALUE_METHOD));
                    data.writeByte(174);
                } else if (rt.equals("double")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_DOUBLE_VALUE_METHOD));
                    data.writeByte(175);
                } else if (rt.equals("byte")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_BYTE_VALUE_METHOD));
                    data.writeByte(172);
                } else if (rt.equals("short")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(NUMBER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(NUMBER_SHORT_VALUE_METHOD));
                    data.writeByte(172);
                } else if (rt.equals("boolean")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(BOOLEAN_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(BOOLEAN_BOOLEAN_VALUE_METHOD));
                    data.writeByte(172);
                } else if (rt.equals("char")) {
                    data.writeByte(192);
                    data.writeShort(cp.put(CHARACTER_IDENTIFIER));
                    data.writeByte(182);
                    data.writeShort(cp.put(CHARACTER_CHAR_VALUE_METHOD));
                    data.writeByte(172);
                } else {
                    data.writeByte(192);
                    data.writeShort(cp.put(new ClassIdentifier(JVMUtilities.getName(rt))));
                    data.writeByte(176);
                }
                short tryEnd = (short)data.size();
                if (ex.length > 0) {
                    maxLocals = (short)(maxLocals + 2);
                    this.astore(maxLocals - 2, data);
                    this.aload(maxLocals - 2, data);
                    data.writeByte(182);
                    data.writeShort(cp.put(this.thrownExceptionMethod));
                    this.astore(maxLocals - 1, data);
                    for (int i = 0; i < ex.length; ++i) {
                        this.aload(maxLocals - 1, data);
                        data.writeByte(193);
                        s = cp.put(new ClassIdentifier(JVMUtilities.getName(ex[i])));
                        data.writeShort(s);
                        data.writeByte(153);
                        if (maxLocals < 5) {
                            data.writeShort(8);
                        } else {
                            data.writeShort(9);
                        }
                        this.aload(maxLocals - 1, data);
                        data.writeByte(192);
                        data.writeShort(s);
                        data.writeByte(191);
                    }
                    this.aload(maxLocals - 2, data);
                    data.writeByte(191);
                }
                CodeAttribute ca = mi.createCodeAttribute();
                ca.setCode(bytes.toByteArray(), maxLocals, maxStack);
                if (ex.length > 0) {
                    ca.addExceptionTableEntry(tryStart, tryEnd, tryEnd, this.thrownExceptionName);
                }
            }
            if (ex.length > 0) {
                ExceptionsAttribute ea = mi.createExceptionsAttribute();
                for (int i = 0; i < ex.length; ++i) {
                    ea.addException(ex[i]);
                }
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getByteCode() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private void iload(int local, DataOutputStream data) throws IOException {
        if (local < 4) {
            data.writeByte(26 + local);
        } else {
            data.writeByte(21);
            data.writeByte(local);
        }
    }

    private void aload(int local, DataOutputStream data) throws IOException {
        if (local < 4) {
            data.writeByte(42 + local);
        } else {
            data.writeByte(25);
            data.writeByte(local);
        }
    }

    private void astore(int local, DataOutputStream data) throws IOException {
        if (local < 4) {
            data.writeByte(75 + local);
        } else {
            data.writeByte(58);
            data.writeByte(local);
        }
    }

    private void bipush(int cst, DataOutputStream data) throws IOException {
        if (cst < 6) {
            data.writeByte(3 + cst);
        } else {
            data.writeByte(16);
            data.writeByte(cst);
        }
    }

    private void loadInt(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(INTEGER_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(26 + currentLocal);
        } else {
            data.writeByte(21);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(INTEGER_CONSTRUCTOR));
    }

    private void loadLong(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(LONG_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(30 + currentLocal);
        } else {
            data.writeByte(22);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(LONG_CONSTRUCTOR));
    }

    private void loadFloat(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(FLOAT_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(34 + currentLocal);
        } else {
            data.writeByte(23);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(FLOAT_CONSTRUCTOR));
    }

    private void loadDouble(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(DOUBLE_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(38 + currentLocal);
        } else {
            data.writeByte(24);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(DOUBLE_CONSTRUCTOR));
    }

    private void loadByte(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(BYTE_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(26 + currentLocal);
        } else {
            data.writeByte(21);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(BYTE_CONSTRUCTOR));
    }

    private void loadShort(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(SHORT_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(26 + currentLocal);
        } else {
            data.writeByte(21);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(SHORT_CONSTRUCTOR));
    }

    private void loadBoolean(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(BOOLEAN_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(26 + currentLocal);
        } else {
            data.writeByte(21);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(BOOLEAN_CONSTRUCTOR));
    }

    private void loadChar(int currentLocal, DataOutputStream data, ConstantPool cp) throws IOException {
        data.writeByte(187);
        data.writeShort(cp.put(CHARACTER_IDENTIFIER));
        data.writeByte(89);
        if (currentLocal < 4) {
            data.writeByte(26 + currentLocal);
        } else {
            data.writeByte(21);
            data.writeByte(currentLocal);
        }
        data.writeByte(183);
        data.writeShort(cp.put(CHARACTER_CONSTRUCTOR));
    }
}

