/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JVMUtilities {
    private static final Map<Class, String> types = new HashMap<Class, String>(11, 1.0f);
    private static final Map<String, String> stypes = new HashMap<String, String>(11, 1.0f);

    public static String getName(Class<?> c) {
        String s = types.get(c);
        if (s != null) {
            return s;
        }
        return c.getName().replace('.', '/');
    }

    public static String getName(String c) {
        String s = stypes.get(c);
        if (s != null) {
            return s;
        }
        if (c.endsWith("[]")) {
            if (c.endsWith("[][]")) {
                return new StringBuffer().append("[").append(JVMUtilities.getName(c.substring(0, c.length() - 2))).toString();
            }
            return new StringBuffer().append("[").append(JVMUtilities.getReturnTypeName(c.substring(0, c.length() - 2))).toString();
        }
        return c.replace('.', '/');
    }

    public static String getReturnTypeName(Class<?> c) {
        String s = types.get(c);
        if (s != null) {
            return s;
        }
        return (c.isArray() ? c.getName() : new StringBuffer().append("L").append(c.getName()).append(";").toString()).replace('.', '/');
    }

    public static String getReturnTypeName(String c) {
        String s = stypes.get(c);
        if (s != null) {
            return s;
        }
        if (c.endsWith("[]")) {
            return new StringBuffer().append("[").append(JVMUtilities.getReturnTypeName(c.substring(0, c.length() - 2))).toString();
        }
        return (c.startsWith("[") ? c : new StringBuffer().append("L").append(c).append(";").toString()).replace('.', '/');
    }

    public static String getParameterTypeName(Class<?> c) {
        return JVMUtilities.getReturnTypeName(c);
    }

    public static String getParameterTypeName(String c) {
        return JVMUtilities.getReturnTypeName(c);
    }

    public static String createMethodDescriptor(String rt, String[] pt) {
        if (pt != null) {
            String result = "(";
            for (int i = 0; i < pt.length; ++i) {
                result = new StringBuffer().append(result).append(pt[i]).toString();
            }
            return new StringBuffer().append(result).append(")").append(rt).toString();
        }
        return rt;
    }

    private JVMUtilities() {
    }

    static {
        types.put(Byte.TYPE, "B");
        types.put(Character.TYPE, "C");
        types.put(Double.TYPE, "D");
        types.put(Float.TYPE, "F");
        types.put(Integer.TYPE, "I");
        types.put(Long.TYPE, "J");
        types.put(Short.TYPE, "S");
        types.put(Boolean.TYPE, "Z");
        types.put(Void.TYPE, "V");
        stypes.put("byte", "B");
        stypes.put("char", "C");
        stypes.put("double", "D");
        stypes.put("float", "F");
        stypes.put("int", "I");
        stypes.put("long", "J");
        stypes.put("short", "S");
        stypes.put("boolean", "Z");
        stypes.put("void", "V");
    }
}

