/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.classloader;

import edu.rice.cs.util.FileOps;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StickyClassLoader
extends ClassLoader {
    private final ClassLoader _newLoader;
    private final String[] _classesToLoadWithOld;

    public StickyClassLoader(ClassLoader newLoader, ClassLoader oldLoader) {
        this(newLoader, oldLoader, new String[0]);
    }

    public StickyClassLoader(ClassLoader newLoader, ClassLoader oldLoader, String[] classesToLoadWithOld) {
        super(oldLoader);
        this._newLoader = newLoader;
        this._classesToLoadWithOld = new String[classesToLoadWithOld.length];
        System.arraycopy(classesToLoadWithOld, 0, this._classesToLoadWithOld, 0, classesToLoadWithOld.length);
        Arrays.sort(this._classesToLoadWithOld);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this._newLoader.getResource(name);
        if (resource == null) {
            resource = this.getParent().getResource(name);
        }
        return resource;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<Object> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.") || name.startsWith("org.omg.") || name.startsWith("sunw.") || name.startsWith("org.w3c.dom.") || name.startsWith("org.xml.sax.") || name.startsWith("net.jini.")) {
            try {
                clazz = StickyClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                clazz = this._loadWithSecondary(name);
            }
        } else {
            clazz = Arrays.binarySearch(this._classesToLoadWithOld, name) >= 0 ? this.getParent().loadClass(name) : this._loadWithSecondary(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class _loadWithSecondary(String name) throws ClassNotFoundException {
        try {
            String fileName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
            URL resource = this.getResource(fileName);
            if (resource == null) {
                throw new ClassNotFoundException(new StringBuffer().append("Resource not found: ").append(fileName).toString());
            }
            byte[] data = FileOps.readStreamAsBytes(resource.openStream());
            return this.defineClass(name, data, 0, data.length);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(ioe.toString());
        }
    }
}

