/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Log {
    public static final boolean ENABLE_ALL = false;
    protected boolean _enabled;
    protected String _name;
    protected PrintWriter _writer;

    public Log(String name, boolean enabled) {
        this._name = name;
        this._enabled = enabled;
        this._init();
    }

    protected void _init() {
        if (this._writer == null && this._enabled) {
            try {
                File f = new File(this._name);
                FileWriter w = new FileWriter(f.getAbsolutePath(), true);
                this._writer = new PrintWriter(w);
                this.logTime("Log '" + this._name + "' opened: " + new Date());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not create log: " + ioe);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public synchronized void log(String message) {
        if (this.isEnabled()) {
            if (this._writer == null) {
                this._init();
            }
            this._writer.println(message);
            this._writer.flush();
        }
    }

    public synchronized void logTime(String message) {
        if (this.isEnabled()) {
            long t = System.currentTimeMillis();
            this.log(t + ": " + message);
        }
    }

    public synchronized void logTime(String s, Throwable t) {
        if (this.isEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.logTime(s + "\n" + sw.toString());
        }
    }
}

