/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.LexicalLiteral;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLiteral
extends LexicalLiteral {
    private final String _value;

    public StringLiteral(SourceInfo in_sourceInfo, String in_value) {
        super(in_sourceInfo);
        if (in_value == null) {
            throw new IllegalArgumentException("Parameter 'value' to the StringLiteral constructor was null. This class may not have null field values.");
        }
        this._value = in_value == null ? null : in_value.intern();
    }

    public final String getValue() {
        return this._value;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forStringLiteral(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forStringLiteral(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("StringLiteral:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("value = ");
        String temp_value = this.getValue();
        if (temp_value == null) {
            writer.print("null");
        } else {
            writer.print(temp_value);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        StringLiteral casted = (StringLiteral)obj;
        return this.getValue() == casted.getValue();
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        return code ^= this.getValue().hashCode();
    }
}

