/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Bob;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.ExpressionTypeChecker;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.PackageData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.ArrayAccess;
import edu.rice.cs.javalanglevels.tree.ComplexNameReference;
import edu.rice.cs.javalanglevels.tree.IncrementExpression;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIF;
import edu.rice.cs.javalanglevels.tree.JExpressionIFAbstractVisitor;
import edu.rice.cs.javalanglevels.tree.NameReference;
import edu.rice.cs.javalanglevels.tree.Parenthesized;
import edu.rice.cs.javalanglevels.tree.SimpleNameReference;
import edu.rice.cs.javalanglevels.tree.Word;
import java.io.File;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LValueWithValueTypeChecker
extends JExpressionIFAbstractVisitor<TypeData> {
    private final TestAssignable _testAssignableInstance;
    private final Bob _bob;

    public LValueWithValueTypeChecker(Bob bob) {
        this._testAssignableInstance = new TestAssignable(bob._data, bob._file, bob._package, bob._importedFiles, bob._importedPackages, bob._vars, bob._thrown);
        this._bob = bob;
    }

    @Override
    public TypeData defaultCase(JExpressionIF that) {
        Bob._addError("You cannot assign a value to an expression of this kind.  Values can only be assigned to fields or variables", that);
        return null;
    }

    @Override
    public TypeData forIncrementExpression(IncrementExpression that) {
        Bob._addError("You cannot assign a value to an increment expression", that);
        return null;
    }

    @Override
    public TypeData forNameReference(NameReference that) {
        return that.visit(this._testAssignableInstance);
    }

    @Override
    public TypeData forArrayAccess(ArrayAccess that) {
        return that.visit(this._testAssignableInstance);
    }

    @Override
    public TypeData forParenthesized(Parenthesized that) {
        return that.getValue().visit(this);
    }

    @Override
    public /* synthetic */ Object forParenthesized(Parenthesized x0) {
        return this.forParenthesized(x0);
    }

    @Override
    public /* synthetic */ Object forArrayAccess(ArrayAccess x0) {
        return this.forArrayAccess(x0);
    }

    @Override
    public /* synthetic */ Object forNameReference(NameReference x0) {
        return this.forNameReference(x0);
    }

    @Override
    public /* synthetic */ Object forIncrementExpression(IncrementExpression x0) {
        return this.forIncrementExpression(x0);
    }

    @Override
    public /* synthetic */ Object defaultCase(JExpressionIF x0) {
        return this.defaultCase(x0);
    }

    static /* synthetic */ TestAssignable access$100(LValueWithValueTypeChecker x0) {
        return x0._testAssignableInstance;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestAssignable
    extends ExpressionTypeChecker {
        public TestAssignable(Data data, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
            super(data, file, packageName, importedFiles, importedPackages, vars, thrown);
        }

        @Override
        public TypeData forSimpleNameReference(SimpleNameReference that) {
            Word myWord = that.getName();
            myWord.visit(this);
            VariableData reference = TestAssignable.getFieldOrVariable(myWord.getText(), this._data, this._data.getSymbolData(), that, this._vars, true, true);
            if (reference != null) {
                if (!reference.hasValue()) {
                    TestAssignable._addError(new StringBuffer().append("You cannot use ").append(reference.getName()).append(" here, because it may not have been given a value").toString(), that.getName());
                } else if (reference.isFinal()) {
                    TestAssignable._addError(new StringBuffer().append("You cannot assign a new value to ").append(reference.getName()).append(" because it is immutable and has already been given a value").toString(), that.getName());
                } else if (!reference.hasModifier("static") && this.inStaticMethod()) {
                    TestAssignable._addError(new StringBuffer().append("Non static field or variable ").append(reference.getName()).append(" cannot be referenced from a static context").toString(), that);
                }
                return reference.getType().getInstanceData();
            }
            SymbolData classR = this.findClassReference(null, myWord.getText(), that);
            if (classR == SymbolData.AMBIGUOUS_REFERENCE) {
                return null;
            }
            if (classR != null && TestAssignable.checkAccessibility(that, classR.getMav(), classR.getName(), classR, this._data.getSymbolData(), "class or interface", false)) {
                return classR;
            }
            PackageData packageD = new PackageData(myWord.getText());
            return packageD;
        }

        @Override
        public TypeData forComplexNameReference(ComplexNameReference that) {
            ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
            TypeData lhs = that.getEnclosing().visit(etc);
            ((LValueWithValueTypeChecker)LValueWithValueTypeChecker.this)._bob.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
            Word myWord = that.getName();
            if (lhs instanceof PackageData) {
                SymbolData classRef = this.findClassReference(lhs, myWord.getText(), that);
                if (classRef != null) {
                    return classRef;
                }
                return new PackageData((PackageData)lhs, myWord.getText());
            }
            VariableData reference = TestAssignable.getFieldOrVariable(myWord.getText(), lhs.getSymbolData(), this._data.getSymbolData(), that);
            if (reference != null) {
                if (lhs instanceof SymbolData && !reference.hasModifier("static")) {
                    TestAssignable._addError(new StringBuffer().append("Non-static variable ").append(reference.getName()).append(" cannot be accessed from the static context ").append(Data.dollarSignsToDots(lhs.getName())).append(".  Perhaps you meant to instantiate an instance of ").append(Data.dollarSignsToDots(lhs.getName())).toString(), that);
                    return reference.getType().getInstanceData();
                }
                if (!reference.hasValue()) {
                    TestAssignable._addError(new StringBuffer().append("You cannot use ").append(reference.getName()).append(" here, because it may not have been given a value").toString(), that.getName());
                }
                if (!this.canBeAssigned(reference)) {
                    TestAssignable._addError(new StringBuffer().append("You cannot assign a new value to ").append(reference.getName()).append(" because it is immutable and has already been given a value").toString(), that.getName());
                }
                return reference.getType().getInstanceData();
            }
            SymbolData sd = this.getSymbolData(true, myWord.getText(), lhs.getSymbolData(), that, false);
            if (sd != null && sd != SymbolData.AMBIGUOUS_REFERENCE) {
                if (!TestAssignable.checkAccessibility(that, sd.getMav(), sd.getName(), sd, this._data.getSymbolData(), "class or interface")) {
                    return null;
                }
                if (!sd.hasModifier("static")) {
                    TestAssignable._addError(new StringBuffer().append("Non-static inner class ").append(Data.dollarSignsToDots(sd.getName())).append(" cannot be accessed from this context.  Perhaps you meant to instantiate it").toString(), that);
                } else if (lhs instanceof InstanceData) {
                    TestAssignable._addError(new StringBuffer().append("You cannot reference the static inner class ").append(Data.dollarSignsToDots(sd.getName())).append(" from an instance of ").append(Data.dollarSignsToDots(lhs.getName())).toString(), that);
                }
                return sd;
            }
            if (sd != SymbolData.AMBIGUOUS_REFERENCE) {
                TestAssignable._addError(new StringBuffer().append("Could not resolve ").append(myWord.getText()).append(" from the context of ").append(Data.dollarSignsToDots(lhs.getName())).toString(), that);
            }
            return null;
        }

        @Override
        public TypeData forArrayAccess(ArrayAccess that) {
            ExpressionTypeChecker etc = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
            TypeData lhs = that.getArray().visit(etc);
            ((LValueWithValueTypeChecker)LValueWithValueTypeChecker.this)._bob.thingsThatHaveBeenAssigned.addAll(etc.thingsThatHaveBeenAssigned);
            ExpressionTypeChecker indexTC = new ExpressionTypeChecker(this._data, this._file, this._package, this._importedFiles, (LinkedList<String>)this._importedPackages, this._vars, this._thrown);
            TypeData index = that.getIndex().visit(indexTC);
            ((LValueWithValueTypeChecker)LValueWithValueTypeChecker.this)._bob.thingsThatHaveBeenAssigned.addAll(indexTC.thingsThatHaveBeenAssigned);
            return this.forArrayAccessOnly(that, lhs, index);
        }

        @Override
        public /* synthetic */ Object forArrayAccess(ArrayAccess x0) {
            return this.forArrayAccess(x0);
        }

        @Override
        public /* synthetic */ Object forComplexNameReference(ComplexNameReference x0) {
            return this.forComplexNameReference(x0);
        }

        @Override
        public /* synthetic */ Object forSimpleNameReference(SimpleNameReference x0) {
            return this.forSimpleNameReference(x0);
        }
    }
}

