/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.ui.MainFrame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFileManager
implements OptionConstants {
    protected int _pos;
    protected Vector<File> _recentFiles;
    protected Vector<JMenuItem> _recentMenuItems;
    protected int MAX = DrJava.getConfig().getSetting(RECENT_FILES_MAX_SIZE);
    protected JMenu _fileMenu;
    protected boolean _isProject;
    MainFrame _frame;

    public RecentFileManager(int pos, JMenu fileMenu, MainFrame frame, boolean isProject) {
        this._pos = pos;
        this._fileMenu = fileMenu;
        this._frame = frame;
        this._recentFiles = new Vector();
        this._recentMenuItems = new Vector();
        this._isProject = isProject;
        Vector files = !this._isProject ? (Vector)DrJava.getConfig().getSetting(RECENT_FILES) : (Vector)DrJava.getConfig().getSetting(RECENT_PROJECTS);
        for (int i = files.size() - 1; i >= 0; --i) {
            this.updateOpenFiles((File)files.get(i));
        }
    }

    public Vector<File> getFileVector() {
        return this._recentFiles;
    }

    public void updateMax(int newMax) {
        this.MAX = newMax;
    }

    public void saveRecentFiles() {
        if (!this._isProject) {
            DrJava.getConfig().setSetting(RECENT_FILES, this._recentFiles);
        } else {
            DrJava.getConfig().setSetting(RECENT_PROJECTS, this._recentFiles);
        }
    }

    public void updateOpenFiles(final File file) {
        if (this._recentMenuItems.size() == 0) {
            this._fileMenu.insertSeparator(this._pos);
            ++this._pos;
        }
        final FileOpenSelector _recentSelector = new FileOpenSelector(){

            public File[] getFiles() {
                return new File[]{file};
            }
        };
        JMenuItem newItem = new JMenuItem("");
        newItem.addActionListener(new AbstractAction(new StringBuffer().append("Open ").append(file.getName()).toString()){

            public void actionPerformed(ActionEvent ae) {
                if (file.getName().endsWith(".pjt")) {
                    RecentFileManager.this._frame.openProject(_recentSelector);
                } else {
                    RecentFileManager.this._frame.open(_recentSelector);
                }
            }
        });
        try {
            newItem.setToolTipText(file.getCanonicalPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        this.removeIfInList(file);
        this._recentMenuItems.add(0, newItem);
        this._recentFiles.add(0, file);
        this.numberItems();
        this._fileMenu.insert(newItem, this._pos);
    }

    public void removeIfInList(File file) {
        File canonical = null;
        try {
            canonical = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        for (int i = 0; i < this._recentFiles.size(); ++i) {
            boolean match;
            File currFile = this._recentFiles.get(i);
            if (canonical != null) {
                try {
                    match = currFile.getCanonicalFile().equals(canonical);
                }
                catch (IOException ioe) {
                    match = currFile.equals(file);
                }
            } else {
                match = currFile.equals(file);
            }
            if (!match) continue;
            this._recentFiles.remove(i);
            JMenuItem menuItem = this._recentMenuItems.get(i);
            this._fileMenu.remove(menuItem);
            this._recentMenuItems.remove(i);
            break;
        }
    }

    public void numberItems() {
        boolean wasEmpty;
        int delPos = this._recentMenuItems.size();
        boolean bl = wasEmpty = delPos == 0;
        while (delPos > this.MAX) {
            JMenuItem delItem = this._recentMenuItems.get(delPos - 1);
            this._recentMenuItems.remove(delPos - 1);
            this._recentFiles.remove(delPos - 1);
            this._fileMenu.remove(delItem);
            delPos = this._recentMenuItems.size();
        }
        for (int i = 0; i < this._recentMenuItems.size(); ++i) {
            JMenuItem currItem = this._recentMenuItems.get(i);
            currItem.setText(new StringBuffer().append(i + 1).append(". ").append(this._recentFiles.get(i).getName()).toString());
        }
        if (this.MAX == 0 && !wasEmpty) {
            this._fileMenu.remove(--this._pos);
        }
    }
}

