/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.FileSelectorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class ProjectPropertiesFrame
extends JFrame {
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 300;
    private JButton _okButton;
    private JButton _applyButton;
    private JButton _cancelButton;
    private JPanel _mainPanel;
    private MainFrame _mainFrame;
    private DirectorySelectorComponent _builtDirSelector;
    private DirectorySelectorComponent _jarMainClassSelector;
    private FileSelectorComponent _jarFileSelector;
    private FileSelectorComponent _manifestFileSelector;
    private VectorFileOptionComponent _extraClasspathList;

    public ProjectPropertiesFrame(MainFrame mf) {
        super("Project Properties");
        this._mainFrame = mf;
        this._mainPanel = new JPanel();
        this._setupPanel(this._mainPanel);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this._mainPanel, "North");
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                successful = ProjectPropertiesFrame.this.saveSettings();
                if (successful) {
                    ProjectPropertiesFrame.this.setVisible(false);
                }
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.saveSettings();
            }
        };
        this._applyButton = new JButton(applyAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        cp.add((Component)bottom, "South");
        this.setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setSize(frameSize);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectPropertiesFrame.this.cancel();
            }
        });
        this.reset();
    }

    public void cancel() {
        this.reset();
        this.setVisible(false);
    }

    private void reset() {
        File f = this._mainFrame.getModel().getBuildDirectory();
        JTextField textField = this._builtDirSelector.getFileField();
        if (f == null) {
            textField.setText("");
        } else {
            this._builtDirSelector.setFileField(f);
        }
        f = this._mainFrame.getModel().getMainClass();
        textField = this._jarMainClassSelector.getFileField();
        if (f == null) {
            textField.setText("");
        } else {
            this._jarMainClassSelector.setFileField(f);
        }
        ClasspathVector cp = this._mainFrame.getModel().getProjectExtraClasspath();
        this._extraClasspathList.setValue(cp.asFileVector());
    }

    public boolean saveSettings() {
        File f = this._builtDirSelector.getFileFromField();
        if (this._builtDirSelector.getFileField().getText().equals("")) {
            f = null;
        }
        this._mainFrame.getModel().setBuildDirectory(f);
        f = this._jarMainClassSelector.getFileFromField();
        if (this._jarMainClassSelector.getFileField().getText().equals("")) {
            f = null;
        }
        this._mainFrame.getModel().setMainClass(f);
        Vector extras = this._extraClasspathList.getValue();
        ClasspathVector cpv = new ClasspathVector();
        Iterator i$ = extras.iterator();
        while (i$.hasNext()) {
            File cf = (File)i$.next();
            cpv.add(cf);
        }
        this._mainFrame.getModel().setProjectExtraClasspath(cpv);
        return true;
    }

    private File _getWorkDir() {
        File workDir = DrJava.getConfig().getSetting(OptionConstants.WORKING_DIRECTORY);
        if (workDir == FileOption.NULL_FILE) {
            workDir = new File(System.getProperty("user.dir"));
        }
        if (workDir.isFile() && workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        return workDir;
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel label = new JLabel("Build Directory");
        label.setToolTipText("<html>The directory the class files will be compiled into.<br>If not specified, the class files will be compiled into<br>the same directory as their corresponding source files</html>");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel dirPanel = this._builtDirectoryPanel();
        gridbag.setConstraints(dirPanel, c);
        panel.add(dirPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel classLabel = new JLabel("Main Document");
        classLabel.setToolTipText("<html>The project document containing the<br><code>main</code>method for the entire project</html>");
        gridbag.setConstraints(classLabel, c);
        panel.add(classLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel mainClassPanel = this._jarMainClassSelector();
        gridbag.setConstraints(mainClassPanel, c);
        panel.add(mainClassPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel extrasLabel = new JLabel("Extra Classpath");
        extrasLabel.setToolTipText("<html>The list of extra classpaths to load with the project.<br>This may include either JAR files or directories. Any<br>classes defined in these classpath locations will be <br>visible in the interactions pane and also accessible <br>by the compiler when compiling the project.</html>");
        gridbag.setConstraints(extrasLabel, c);
        panel.add(extrasLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component extrasComponent = this._extraClasspathComponent();
        gridbag.setConstraints(extrasComponent, c);
        panel.add(extrasComponent);
    }

    public JPanel _builtDirectoryPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        dirChooser.setSelectedDirectory(this._getWorkDir());
        dirChooser.setDialogTitle("Select Build Directory");
        dirChooser.setApproveButtonText("Select");
        dirChooser.setEditable(true);
        this._builtDirSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f);
        return this._builtDirSelector;
    }

    public Component _extraClasspathComponent() {
        this._extraClasspathList = new VectorFileOptionComponent(null, "Extra Project Classpaths", (Frame)this);
        return this._extraClasspathList.getComponent();
    }

    public JPanel _jarMainClassSelector() {
        File rootFile = this._mainFrame.getModel().getProjectFile();
        try {
            rootFile = rootFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        DirectoryChooser chooser = new DirectoryChooser((Frame)this, rootFile);
        chooser.setDialogTitle("Select Main Document");
        chooser.setTopMessage("Select the main document for the project:");
        chooser.setApproveButtonText("Select");
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                return !f.isDirectory() && (name.endsWith(".java") || name.endsWith(".dj0") || name.endsWith(".dj1") || name.endsWith(".dj2"));
            }

            public String getDescription() {
                return "Java & DrJava Files (*.java, *.dj0, *.dj1, *.dj2)";
            }
        };
        chooser.addChoosableFileFilter(filter);
        chooser.addFileFilter(filter);
        chooser.setShowFiles(true);
        chooser.setFileDisplayManager(MainFrame.getFileDisplayManager20());
        this._jarMainClassSelector = new DirectorySelectorComponent(this, chooser, 20, 12.0f);
        return this._jarMainClassSelector;
    }

    public JPanel _manifestFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._mainFrame.getModel().getProjectFile().getParentFile());
        fileChooser.setDialogTitle("Select Output jar File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        this._manifestFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f);
        this._manifestFileSelector.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._manifestFileSelector;
    }

    public JPanel _jarFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._mainFrame.getModel().getProjectFile().getParentFile());
        fileChooser.setDialogTitle("Select Manifest File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        this._jarFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f);
        this._jarFileSelector.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.reset();
    }
}

